/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.base.TileNetworkList;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    public boolean seesSun = false;
    public double GENERATION_RATE;
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getSeesSun"};

    public TileEntitySolarGenerator() {
        this("SolarGenerator", 96000.0, MekanismConfig.generators.solarGeneration * 2.0);
        this.GENERATION_RATE = MekanismConfig.generators.solarGeneration;
    }

    public TileEntitySolarGenerator(String name, double maxEnergy, double output) {
        super("solar", name, maxEnergy, output);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return 0.05f * super.getVolume();
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)0, (IStrictEnergyStorage)this);
            this.seesSun = this.field_145850_b.func_72935_r() && (!this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() || this.isDesert()) && !this.field_145850_b.field_73011_w.func_177495_o() && this.field_145850_b.func_175678_i(this.func_174877_v().func_177982_a(0, 4, 0));
            if (this.canOperate()) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() + this.getProduction());
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean isDesert() {
        return this.field_145850_b.field_73011_w.getBiomeForCoords(this.func_174877_v()).func_150562_l() == BiomeDesert.class;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.getEnergy() < this.getMaxEnergy() && this.seesSun && MekanismUtils.canFunction((TileEntity)this);
    }

    public double getProduction() {
        if (this.seesSun) {
            double ret = this.GENERATION_RATE;
            if (MekanismUtils.existsAndInstance((Object)this.field_145850_b.field_73011_w, (String)"micdoodle8.mods.galacticraft.api.world.ISolarLevel")) {
                ret *= ((ISolarLevel)this.field_145850_b.field_73011_w).getSolarEnergyMultiplier();
            }
            if (this.isDesert()) {
                ret *= 1.5;
            }
            return ret;
        }
        return 0.0;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.seesSun};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.seesSun = dataStream.readBoolean();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.seesSun);
        return data;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }
}

