/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public enum EnumColor implements IStringSerializable
{
    BLACK("\u00a70", "black", "Black", new int[]{0, 0, 0}, 0, TextFormatting.BLACK),
    DARK_BLUE("\u00a71", "darkBlue", "Blue", new int[]{0, 0, 170}, 4, TextFormatting.DARK_BLUE),
    DARK_GREEN("\u00a72", "darkGreen", "Green", new int[]{0, 170, 0}, 2, TextFormatting.DARK_GREEN),
    DARK_AQUA("\u00a73", "darkAqua", "Cyan", new int[]{0, 255, 255}, 6, TextFormatting.DARK_AQUA),
    DARK_RED("\u00a74", "darkRed", null, new int[]{170, 0, 0}, -1, TextFormatting.DARK_RED),
    PURPLE("\u00a75", "purple", "Purple", new int[]{170, 0, 170}, 5, TextFormatting.DARK_PURPLE),
    ORANGE("\u00a76", "orange", "Orange", new int[]{255, 170, 0}, 14, TextFormatting.GOLD),
    GREY("\u00a77", "grey", "LightGray", new int[]{170, 170, 170}, 7, TextFormatting.GRAY),
    DARK_GREY("\u00a78", "darkGrey", "Gray", new int[]{85, 85, 85}, 8, TextFormatting.DARK_GRAY),
    INDIGO("\u00a79", "indigo", "LightBlue", new int[]{85, 85, 255}, 12, TextFormatting.BLUE),
    BRIGHT_GREEN("\u00a7a", "brightGreen", "Lime", new int[]{85, 255, 85}, 10, TextFormatting.GREEN),
    AQUA("\u00a7b", "aqua", null, new int[]{85, 255, 255}, -1, TextFormatting.AQUA),
    RED("\u00a7c", "red", "Red", new int[]{255, 0, 0}, 1, TextFormatting.RED),
    PINK("\u00a7d", "pink", "Magenta", new int[]{255, 85, 255}, 13, TextFormatting.LIGHT_PURPLE),
    YELLOW("\u00a7e", "yellow", "Yellow", new int[]{255, 255, 85}, 11, TextFormatting.YELLOW),
    WHITE("\u00a7f", "white", "White", new int[]{255, 255, 255}, 15, TextFormatting.WHITE),
    BROWN("\u00a76", "brown", "Brown", new int[]{150, 75, 0}, 3, TextFormatting.GOLD),
    BRIGHT_PINK("\u00a7d", "brightPink", "Pink", new int[]{255, 192, 203}, 9, TextFormatting.LIGHT_PURPLE);

    public static EnumColor[] DYES;
    public final String code;
    public final int[] rgbCode;
    public final int mcMeta;
    public String unlocalizedName;
    public String dyeName;
    public final TextFormatting textFormatting;

    private EnumColor(String s, String n2, String dye, int[] rgb, int meta, TextFormatting tf) {
        this.code = s;
        this.unlocalizedName = n2;
        this.dyeName = dye;
        this.rgbCode = rgb;
        this.mcMeta = meta;
        this.textFormatting = tf;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)("color." + this.unlocalizedName));
    }

    public String getUnlocalizedName() {
        return "color." + this.unlocalizedName;
    }

    public String getDyeName() {
        return I18n.func_74838_a((String)("dye." + this.unlocalizedName));
    }

    public String getOreDictName() {
        return this.dyeName;
    }

    public String getColoredName() {
        return this.code + this.getLocalizedName();
    }

    public ITextComponent getTranslatedColouredComponent() {
        TextComponentTranslation t = new TextComponentTranslation(this.getUnlocalizedName(), new Object[0]);
        t.func_150256_b().func_150238_a(this.textFormatting);
        return t;
    }

    public String getDyedName() {
        return this.code + this.getDyeName();
    }

    public String func_176610_l() {
        return this.unlocalizedName.toLowerCase();
    }

    public float getColor(int index) {
        return (float)this.rgbCode[index] / 255.0f;
    }

    public int getMetaValue() {
        return this.mcMeta;
    }

    public String toString() {
        return this.code;
    }

    public static EnumColor getFromDyeName(String s) {
        for (EnumColor c : EnumColor.values()) {
            if (!c.dyeName.equalsIgnoreCase(s)) continue;
            return c;
        }
        return null;
    }

    static {
        DYES = new EnumColor[]{BLACK, RED, DARK_GREEN, BROWN, DARK_BLUE, PURPLE, DARK_AQUA, GREY, DARK_GREY, BRIGHT_PINK, BRIGHT_GREEN, YELLOW, INDIGO, PINK, ORANGE, WHITE};
    }
}

