/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class MekKeyHandler {
    public KeyBinding[] keyBindings;
    public boolean[] keyDown;
    public boolean[] repeatings;
    public boolean isDummy;

    public MekKeyHandler(KeyBinding[] bindings, boolean[] rep) {
        assert (this.keyBindings.length == this.repeatings.length) : "You need to pass two arrays of identical length";
        this.keyBindings = bindings;
        this.repeatings = rep;
        this.keyDown = new boolean[this.keyBindings.length];
    }

    public MekKeyHandler(KeyBinding[] bindings) {
        this.keyBindings = bindings;
        this.isDummy = true;
    }

    public static boolean getIsKeyPressed(KeyBinding keyBinding) {
        try {
            int keyCode = keyBinding.func_151463_i();
            return keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public KeyBinding[] getKeyBindings() {
        return this.keyBindings;
    }

    public void keyTick() {
        for (int i = 0; i < this.keyBindings.length; ++i) {
            KeyBinding keyBinding = this.keyBindings[i];
            boolean state = keyBinding.func_151468_f();
            if (state == this.keyDown[i] && (!state || !this.repeatings[i])) continue;
            if (state) {
                this.keyDown(keyBinding, state == this.keyDown[i]);
            } else {
                this.keyUp(keyBinding);
            }
            this.keyDown[i] = state;
        }
    }

    public abstract void keyDown(KeyBinding var1, boolean var2);

    public abstract void keyUp(KeyBinding var1);
}

