/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketSecurityMode;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSecurityTab
extends GuiElement {
    public boolean isItem;
    public EnumHand currentHand;
    public TileEntity tileEntity;

    public GuiSecurityTab(IGuiWrapper gui, TileEntity tile, ResourceLocation def) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSecurityTab.png"), gui, def);
        this.tileEntity = tile;
    }

    public GuiSecurityTab(IGuiWrapper gui, ResourceLocation def, EnumHand hand) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSecurityTab.png"), gui, def);
        this.isItem = true;
        this.currentHand = hand;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + 176, guiHeight + 32, 26, 26);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + 176, guiHeight + 32, 0, 0, 26, 26);
        ISecurityTile.SecurityMode mode = this.getSecurity();
        SecurityData data = MekanismClient.clientSecurityMap.get(this.getOwner());
        if (data != null && data.override) {
            mode = data.mode;
        }
        int renderX = 26 + 18 * mode.ordinal();
        if (this.getOwner() != null && this.getOwner().equals(GuiSecurityTab.mc.field_71439_g.func_110124_au()) && (data == null || !data.override)) {
            if (xAxis >= 179 && xAxis <= 197 && yAxis >= 36 && yAxis <= 54) {
                this.guiObj.drawTexturedRect(guiWidth + 179, guiHeight + 36, renderX, 0, 18, 18);
            } else {
                this.guiObj.drawTexturedRect(guiWidth + 179, guiHeight + 36, renderX, 18, 18, 18);
            }
        } else {
            this.guiObj.drawTexturedRect(guiWidth + 179, guiHeight + 36, renderX, 36, 18, 18);
        }
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (xAxis >= 179 && xAxis <= 197 && yAxis >= 36 && yAxis <= 54) {
            String securityDisplay = this.isItem ? SecurityUtils.getSecurityDisplay(this.getItem(), Side.CLIENT) : SecurityUtils.getSecurityDisplay(this.tileEntity, Side.CLIENT);
            String securityText = (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + securityDisplay;
            String ownerText = SecurityUtils.getOwnerDisplay((EntityPlayer)GuiSecurityTab.mc.field_71439_g, this.getOwnerUsername());
            String overrideText = (Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")";
            if (this.isItem ? SecurityUtils.isOverridden(this.getItem(), Side.CLIENT) : SecurityUtils.isOverridden(this.tileEntity, Side.CLIENT)) {
                this.displayTooltips(ListUtils.asList(securityText, ownerText, overrideText), xAxis, yAxis);
            } else {
                this.displayTooltips(ListUtils.asList(securityText, ownerText), xAxis, yAxis);
            }
        }
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    private SecurityFrequency getFrequency() {
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return null;
            }
            return SecurityUtils.getFrequency(this.getOwner());
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getFrequency();
    }

    private ISecurityTile.SecurityMode getSecurity() {
        if (!MekanismConfig.general.allowProtection) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return ISecurityTile.SecurityMode.PUBLIC;
            }
            return ((ISecurityItem)this.getItem().func_77973_b()).getSecurity(this.getItem());
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getMode();
    }

    private UUID getOwner() {
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return null;
            }
            return ((ISecurityItem)this.getItem().func_77973_b()).getOwnerUUID(this.getItem());
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getOwnerUUID();
    }

    private String getOwnerUsername() {
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return null;
            }
            return MekanismClient.clientUUIDMap.get(((ISecurityItem)this.getItem().func_77973_b()).getOwnerUUID(this.getItem()));
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getClientOwner();
    }

    private ItemStack getItem() {
        return GuiSecurityTab.mc.field_71439_g.func_184586_b(this.currentHand);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (button == 0 && MekanismConfig.general.allowProtection && this.getOwner() != null && GuiSecurityTab.mc.field_71439_g.func_110124_au().equals(this.getOwner()) && xAxis >= 179 && xAxis <= 197 && yAxis >= 36 && yAxis <= 54) {
            ISecurityTile.SecurityMode current = this.getSecurity();
            int ordinalToSet = current.ordinal() < ISecurityTile.SecurityMode.values().length - 1 ? current.ordinal() + 1 : 0;
            SoundHandler.playSound(SoundEvents.field_187909_gi);
            if (this.isItem) {
                Mekanism.packetHandler.sendToServer(new PacketSecurityMode.SecurityModeMessage(this.currentHand, ISecurityTile.SecurityMode.values()[ordinalToSet]));
            } else {
                Mekanism.packetHandler.sendToServer(new PacketSecurityMode.SecurityModeMessage(Coord4D.get(this.tileEntity), ISecurityTile.SecurityMode.values()[ordinalToSet]));
            }
        }
    }
}

