/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.PRCRecipeWrapper;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.util.ResourceLocation;

public class PRCRecipeCategory
extends BaseRecipeCategory {
    private final IDrawable background;
    @Nullable
    private PressurizedRecipe tempRecipe;

    public PRCRecipeCategory(IGuiHelper helper) {
        super(helper, "mekanism:gui/nei/GuiPRC.png", "pressurized_reaction_chamber", "tile.MachineBlock2.PressurizedReactionChamber.short.name", GuiProgress.ProgressBar.MEDIUM);
        this.xOffset = 3;
        this.yOffset = 11;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 170, 68);
    }

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, this.guiLocation, 53, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.guiLocation, 140, 18).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, this.guiLocation, 115, 34));
        this.guiElements.add(GuiFluidGauge.getDummy(GuiGauge.Type.STANDARD_YELLOW, this, this.guiLocation, 5, 10));
        this.guiElements.add(GuiGasGauge.getDummy(GuiGauge.Type.STANDARD_RED, this, this.guiLocation, 28, 10));
        this.guiElements.add(GuiGasGauge.getDummy(GuiGauge.Type.SMALL_BLUE, this, this.guiLocation, 140, 40));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return 1.0;
            }
        }, this.guiLocation, 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (float)PRCRecipeCategory.this.timer.getValue() / 20.0f;
            }
        }, this.progressBar, this, this.guiLocation, 75, 37));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (!(recipeWrapper instanceof PRCRecipeWrapper)) {
            return;
        }
        this.tempRecipe = ((PRCRecipeWrapper)recipeWrapper).getRecipe();
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 53 - this.xOffset, 34 - this.yOffset);
        itemStacks.init(1, false, 115 - this.xOffset, 34 - this.yOffset);
        itemStacks.set(0, ((PressurizedInput)this.tempRecipe.recipeInput).getSolid());
        itemStacks.set(1, ((PressurizedOutput)this.tempRecipe.recipeOutput).getItemOutput());
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 3, 0, 16, 58, ((PressurizedInput)this.tempRecipe.getInput()).getFluid().amount, false, this.fluidOverlayLarge);
        fluidStacks.set(0, ((PressurizedInput)this.tempRecipe.recipeInput).getFluid());
        fluidStacks.addTooltipCallback((index, input, ingredient, tooltip) -> {
            String cfr_ignored_0 = (String)tooltip.remove(1);
        });
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(GasStack.class);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, true, 29 - this.xOffset, 11 - this.yOffset, 16, 58, ((PressurizedInput)this.tempRecipe.recipeInput).getGas(), true);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 1, false, 141 - this.xOffset, 41 - this.yOffset, 16, 28, ((PressurizedOutput)this.tempRecipe.recipeOutput).getGasOutput(), true);
    }
}

