/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;
import mekanism.client.voice.VoiceInput;
import mekanism.client.voice.VoiceOutput;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VoiceClient
extends Thread {
    public Socket socket;
    public String ip;
    public AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, true);
    public VoiceInput inputThread;
    public VoiceOutput outputThread;
    public DataInputStream input;
    public DataOutputStream output;
    public boolean running;

    public VoiceClient(String s) {
        this.ip = s;
    }

    @Override
    public void run() {
        Mekanism.logger.info("VoiceServer: Starting client connection...");
        try {
            this.socket = new Socket(this.ip, MekanismConfig.general.VOICE_PORT);
            this.running = true;
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.outputThread = new VoiceOutput(this);
            this.outputThread.start();
            this.inputThread = new VoiceInput(this);
            this.inputThread.start();
            Mekanism.logger.info("VoiceServer: Successfully connected to server.");
        }
        catch (ConnectException e) {
            Mekanism.logger.error("VoiceServer: Server's VoiceServer is disabled.");
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while starting client connection.");
            e.printStackTrace();
        }
    }

    public void disconnect() {
        Mekanism.logger.info("VoiceServer: Stopping client connection...");
        try {
            this.inputThread.interrupt();
            this.outputThread.interrupt();
            this.inputThread.close();
            this.outputThread.close();
            this.output.close();
            this.input.close();
            this.socket.close();
            this.interrupt();
            this.running = false;
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while stopping client connection.");
            e.printStackTrace();
        }
    }
}

