/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.base.TileNetworkList;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.StackSearcher;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TMaterialFilter;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.content.transporter.TOreDictFilter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TransporterFilter {
    public static final int MAX_LENGTH = 24;
    public static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('*'), Character.valueOf('-'), Character.valueOf(' '), Character.valueOf('|'), Character.valueOf('_'), Character.valueOf('\''));
    public EnumColor color;
    public boolean allowDefault;

    public abstract boolean canFilter(ItemStack var1, boolean var2);

    public abstract Finder getFinder();

    public InvStack getStackFromInventory(StackSearcher searcher) {
        return searcher.takeTopStack(this.getFinder());
    }

    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("allowDefault", this.allowDefault);
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
    }

    protected void read(NBTTagCompound nbtTags) {
        this.allowDefault = nbtTags.func_74767_n("allowDefault");
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
    }

    public void write(TileNetworkList data) {
        data.add(this.allowDefault);
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
    }

    protected void read(ByteBuf dataStream) {
        this.allowDefault = dataStream.readBoolean();
        int c = dataStream.readInt();
        this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
    }

    public static TransporterFilter readFromNBT(NBTTagCompound nbtTags) {
        int type = nbtTags.func_74762_e("type");
        TransporterFilter filter = null;
        if (type == 0) {
            filter = new TItemStackFilter();
        } else if (type == 1) {
            filter = new TOreDictFilter();
        } else if (type == 2) {
            filter = new TMaterialFilter();
        } else if (type == 3) {
            filter = new TModIDFilter();
        }
        ((TransporterFilter)filter).read(nbtTags);
        return filter;
    }

    public static TransporterFilter readFromPacket(ByteBuf dataStream) {
        int type = dataStream.readInt();
        TransporterFilter filter = null;
        if (type == 0) {
            filter = new TItemStackFilter();
        } else if (type == 1) {
            filter = new TOreDictFilter();
        } else if (type == 2) {
            filter = new TMaterialFilter();
        } else if (type == 3) {
            filter = new TModIDFilter();
        }
        ((TransporterFilter)filter).read(dataStream);
        return filter;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + (this.color != null ? this.color.ordinal() : -1);
        return code;
    }

    public boolean equals(Object filter) {
        return filter instanceof TransporterFilter && ((TransporterFilter)filter).color == this.color;
    }
}

