/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public class TransporterManager {
    public static Map<Coord4D, Set<TransporterStack>> flowingStacks = new HashMap<Coord4D, Set<TransporterStack>>();

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(TransporterStack stack) {
        HashSet<TransporterStack> set = new HashSet<TransporterStack>();
        set.add(stack);
        if (flowingStacks.get(stack.getDest()) == null) {
            flowingStacks.put(stack.getDest(), set);
        } else {
            flowingStacks.get(stack.getDest()).addAll(set);
        }
    }

    public static void remove(TransporterStack stack) {
        if (stack.hasPath() && stack.pathType != TransporterStack.Path.NONE) {
            flowingStacks.get(stack.getDest()).remove(stack);
        }
    }

    public static List<TransporterStack> getStacksToDest(Coord4D dest) {
        ArrayList<TransporterStack> ret = new ArrayList<TransporterStack>();
        if (flowingStacks.containsKey(dest)) {
            for (TransporterStack stack : flowingStacks.get(dest)) {
                if (stack == null || stack.pathType == TransporterStack.Path.NONE || !stack.hasPath() || !stack.getDest().equals(dest)) continue;
                ret.add(stack);
            }
        }
        return ret;
    }

    public static InventoryCopy copyInv(IItemHandler handler) {
        NonNullList ret = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ret.set(i, (Object)handler.getStackInSlot(i));
        }
        return new InventoryCopy((NonNullList<ItemStack>)ret);
    }

    public static InventoryCopy copyInvFromSide(IInventory inv, EnumFacing side) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!(inv instanceof ISidedInventory)) {
            for (int i = 0; i <= inv.func_70302_i_() - 1; ++i) {
                ret.set(i, (Object)(!inv.func_70301_a(i).func_190926_b() ? inv.func_70301_a(i).func_77946_l() : ItemStack.field_190927_a));
            }
        } else {
            ISidedInventory sidedInventory = (ISidedInventory)inv;
            int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
            if (slots == null || slots.length == 0) {
                return null;
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                int slotID = slots[get];
                if (slotID >= ret.size()) {
                    Mekanism.logger.error("Inventory {} gave slot number >= the number of slots it reported! {} >= {} ", (Object)inv.getClass().getName(), (Object)slotID, (Object)ret.size());
                    continue;
                }
                ret.set(slotID, (Object)(!sidedInventory.func_70301_a(slotID).func_190926_b() ? sidedInventory.func_70301_a(slotID).func_77946_l() : ItemStack.field_190927_a));
            }
            if (inv instanceof TileEntityBin) {
                return new InventoryCopy((NonNullList<ItemStack>)ret, ((TileEntityBin)inv).getItemCount());
            }
            return new InventoryCopy((NonNullList<ItemStack>)ret);
        }
        return new InventoryCopy((NonNullList<ItemStack>)ret);
    }

    public static void testInsert(TileEntity tile, InventoryCopy copy, EnumFacing side, TransporterStack stack) {
        block21: {
            ItemStack inSlot;
            IInventory inv;
            ItemStack toInsert;
            block20: {
                toInsert = stack.itemStack.func_77946_l();
                if (stack.pathType != TransporterStack.Path.HOME && tile instanceof ISideConfiguration) {
                    ISideConfiguration config = (ISideConfiguration)tile;
                    EnumFacing tileSide = config.getOrientation();
                    EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
                    if (config.getEjector().hasStrictInput() && configColor != null && configColor != stack.color) {
                        return;
                    }
                }
                if (!(tile instanceof ISidedInventory)) break block20;
                ISidedInventory sidedInventory = (ISidedInventory)tile;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots == null || slots.length == 0) break block21;
                if (stack.pathType != TransporterStack.Path.HOME && sidedInventory instanceof TileEntityBin && side.func_176734_d() == EnumFacing.DOWN) {
                    slots = sidedInventory.func_180463_a(EnumFacing.UP);
                }
                if (tile instanceof TileEntityBin) {
                    int slot = slots[0];
                    if (!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_180462_a(slot, toInsert, side.func_176734_d())) {
                        return;
                    }
                    int amountRemaining = ((TileEntityBin)sidedInventory).getMaxStoredCount() - copy.binAmount;
                    copy.binAmount += Math.min(amountRemaining, toInsert.func_190916_E());
                    return;
                }
                for (int get = 0; get <= slots.length - 1; ++get) {
                    ItemStack toSet;
                    int slotID = slots[get];
                    if (stack.pathType != TransporterStack.Path.HOME && (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d()))) continue;
                    ItemStack inSlot2 = (ItemStack)copy.inventory.get(slotID);
                    if (inSlot2.func_190926_b()) {
                        if (toInsert.func_190916_E() <= sidedInventory.func_70297_j_()) {
                            copy.inventory.set(slotID, (Object)toInsert);
                            return;
                        }
                        int rejects = toInsert.func_190916_E() - sidedInventory.func_70297_j_();
                        toSet = toInsert.func_77946_l();
                        toSet.func_190920_e(sidedInventory.func_70297_j_());
                        ItemStack remains = toInsert.func_77946_l();
                        remains.func_190920_e(rejects);
                        copy.inventory.set(slotID, (Object)toSet);
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot2) || inSlot2.func_190916_E() >= Math.min(inSlot2.func_77976_d(), sidedInventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot2.func_77976_d(), sidedInventory.func_70297_j_());
                    if (inSlot2.func_190916_E() + toInsert.func_190916_E() <= max) {
                        toSet = toInsert.func_77946_l();
                        toSet.func_190917_f(inSlot2.func_190916_E());
                        copy.inventory.set(slotID, (Object)toSet);
                        return;
                    }
                    int rejects = inSlot2.func_190916_E() + toInsert.func_190916_E() - max;
                    ItemStack toSet2 = toInsert.func_77946_l();
                    toSet2.func_190920_e(max);
                    ItemStack remains = toInsert.func_77946_l();
                    remains.func_190920_e(rejects);
                    copy.inventory.set(slotID, (Object)toSet2);
                    toInsert = remains;
                }
                break block21;
            }
            if (tile instanceof IInventory) {
                inv = InventoryUtils.checkChestInv((IInventory)tile);
                for (int i = 0; i <= inv.func_70302_i_() - 1; ++i) {
                    if (stack.pathType != TransporterStack.Path.HOME && !inv.func_94041_b(i, toInsert)) continue;
                    inSlot = (ItemStack)copy.inventory.get(i);
                    if (inSlot.func_190926_b()) {
                        if (toInsert.func_190916_E() <= inv.func_70297_j_()) {
                            copy.inventory.set(i, (Object)toInsert);
                            return;
                        }
                        int rejects = toInsert.func_190916_E() - inv.func_70297_j_();
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.func_190920_e(inv.func_70297_j_());
                        ItemStack remains = toInsert.func_77946_l();
                        remains.func_190920_e(rejects);
                        copy.inventory.set(i, (Object)toSet);
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), inv.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inv.func_70297_j_());
                    if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.func_190917_f(inSlot.func_190916_E());
                        copy.inventory.set(i, (Object)toSet);
                        return;
                    }
                    int rejects = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.func_190920_e(max);
                    ItemStack remains = toInsert.func_77946_l();
                    remains.func_190920_e(rejects);
                    copy.inventory.set(i, (Object)toSet);
                    toInsert = remains;
                }
            } else if (InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
                inv = InventoryUtils.getItemHandler(tile, side.func_176734_d());
                for (int i = 0; i <= inv.getSlots() - 1; ++i) {
                    ItemStack rejectStack;
                    if (stack.pathType != TransporterStack.Path.HOME && !TransporterManager.didEmit(toInsert, rejectStack = inv.insertItem(i, toInsert, true))) continue;
                    inSlot = (ItemStack)copy.inventory.get(i);
                    if (inSlot.func_190926_b()) {
                        if (toInsert.func_190916_E() <= inv.getSlotLimit(i)) {
                            copy.inventory.set(i, (Object)toInsert);
                            return;
                        }
                        int rejects = toInsert.func_190916_E() - inv.getSlotLimit(i);
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.func_190920_e(inv.getSlotLimit(i));
                        ItemStack remains = toInsert.func_77946_l();
                        remains.func_190920_e(rejects);
                        copy.inventory.set(i, (Object)toSet);
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), inv.getSlotLimit(i))) continue;
                    int max = Math.min(inSlot.func_77976_d(), inv.getSlotLimit(i));
                    if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.func_190917_f(inSlot.func_190916_E());
                        copy.inventory.set(i, (Object)toSet);
                        return;
                    }
                    int rejects = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.func_190920_e(max);
                    ItemStack remains = toInsert.func_77946_l();
                    remains.func_190920_e(rejects);
                    copy.inventory.set(i, (Object)toSet);
                    toInsert = remains;
                }
            }
        }
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() || returned.func_190916_E() < stack.func_190916_E();
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        if (returned.func_190926_b() || returned.func_190916_E() == 0) {
            return stack;
        }
        return MekanismUtils.size(stack, stack.func_190916_E() - returned.func_190916_E());
    }

    public static ItemStack getToUse(ItemStack stack, int rejected) {
        return MekanismUtils.size(stack, stack.func_190916_E() - rejected);
    }

    public static TransitRequest.TransitResponse getPredictedInsert(TileEntity tileEntity, EnumColor color, TransitRequest request, EnumFacing side) {
        if (tileEntity instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)tileEntity;
            EnumFacing tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
            if (config.getEjector().hasStrictInput() && configColor != null && configColor != color) {
                return TransitRequest.TransitResponse.EMPTY;
            }
        }
        InventoryCopy copy = null;
        if (tileEntity instanceof IInventory) {
            copy = TransporterManager.copyInvFromSide(InventoryUtils.checkChestInv((IInventory)tileEntity), side);
        } else if (InventoryUtils.isItemHandler(tileEntity, side.func_176734_d())) {
            copy = TransporterManager.copyInv(InventoryUtils.getItemHandler(tileEntity, side.func_176734_d()));
        }
        if (copy == null) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        List<TransporterStack> insertQueue = TransporterManager.getStacksToDest(Coord4D.get(tileEntity));
        for (TransporterStack transporterStack : insertQueue) {
            TransporterManager.testInsert(tileEntity, copy, side, transporterStack);
        }
        for (Map.Entry entry : request.itemMap.entrySet()) {
            IInventory inventory;
            int rejects;
            ItemStack toInsert = ((ItemStack)entry.getKey()).func_77946_l();
            if (tileEntity instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)tileEntity;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots == null || slots.length == 0) continue;
                if (tileEntity instanceof TileEntityBin) {
                    int slot = slots[0];
                    if (!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_180462_a(slot, toInsert, side.func_176734_d())) continue;
                    int amountRemaining = ((TileEntityBin)tileEntity).getMaxStoredCount() - copy.binAmount;
                    ItemStack ret = toInsert.func_190916_E() <= amountRemaining ? toInsert : StackUtils.size(toInsert, amountRemaining);
                    return new TransitRequest.TransitResponse((Integer)entry.getValue(), ret);
                }
                for (int get = 0; get <= slots.length - 1; ++get) {
                    int slotID = slots[get];
                    if (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d())) continue;
                    ItemStack inSlot = (ItemStack)copy.inventory.get(slotID);
                    if (toInsert.func_190926_b()) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    if (inSlot.func_190926_b()) {
                        if (toInsert.func_190916_E() <= sidedInventory.func_70297_j_()) {
                            return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                        }
                        rejects = toInsert.func_190916_E() - sidedInventory.func_70297_j_();
                        if (rejects >= toInsert.func_190916_E()) continue;
                        toInsert = StackUtils.size(toInsert, rejects);
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_());
                    if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    int rejects2 = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                    if (rejects2 >= toInsert.func_190916_E()) continue;
                    toInsert = StackUtils.size(toInsert, rejects2);
                }
                if (!TransporterManager.didEmit((ItemStack)entry.getKey(), toInsert)) continue;
                return new TransitRequest.TransitResponse((Integer)entry.getValue(), TransporterManager.getToUse((ItemStack)entry.getKey(), toInsert));
            }
            if (tileEntity instanceof IInventory) {
                inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!inventory.func_94041_b(i, toInsert)) continue;
                    ItemStack inSlot = (ItemStack)copy.inventory.get(i);
                    if (toInsert.func_190926_b()) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    if (inSlot.func_190926_b()) {
                        if (toInsert.func_190916_E() <= inventory.func_70297_j_()) {
                            return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                        }
                        int rejects3 = toInsert.func_190916_E() - inventory.func_70297_j_();
                        if (rejects3 >= toInsert.func_190916_E()) continue;
                        toInsert = StackUtils.size(toInsert, rejects3);
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), inventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
                    if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    int rejects4 = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                    if (rejects4 >= toInsert.func_190916_E()) continue;
                    toInsert = StackUtils.size(toInsert, rejects4);
                }
                if (!TransporterManager.didEmit((ItemStack)entry.getKey(), toInsert)) continue;
                return new TransitRequest.TransitResponse((Integer)entry.getValue(), TransporterManager.getToUse((ItemStack)entry.getKey(), toInsert));
            }
            if (!InventoryUtils.isItemHandler(tileEntity, side.func_176734_d())) continue;
            inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
            for (int i = 0; i <= inventory.getSlots() - 1; ++i) {
                ItemStack rejectStack = inventory.insertItem(i, toInsert, true);
                if (!TransporterManager.didEmit(toInsert, rejectStack)) continue;
                ItemStack inSlot = (ItemStack)copy.inventory.get(i);
                if (toInsert.func_190926_b()) {
                    return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                }
                if (inSlot.func_190926_b()) {
                    if (toInsert.func_190916_E() <= inventory.getSlotLimit(i)) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    int rejects5 = toInsert.func_190916_E() - inventory.getSlotLimit(i);
                    if (rejects5 >= toInsert.func_190916_E()) continue;
                    toInsert = StackUtils.size(toInsert, rejects5);
                    continue;
                }
                if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), inventory.getSlotLimit(i))) continue;
                int max = Math.min(inSlot.func_77976_d(), inventory.getSlotLimit(i));
                if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                    return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                }
                rejects = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                if (rejects >= toInsert.func_190916_E()) continue;
                toInsert = StackUtils.size(toInsert, rejects);
            }
            if (!TransporterManager.didEmit((ItemStack)entry.getKey(), toInsert)) continue;
            return new TransitRequest.TransitResponse((Integer)entry.getValue(), TransporterManager.getToUse((ItemStack)entry.getKey(), toInsert));
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    public static class InventoryCopy {
        public NonNullList<ItemStack> inventory;
        public int binAmount;

        public InventoryCopy(NonNullList<ItemStack> inv) {
            this.inventory = inv;
        }

        public InventoryCopy(NonNullList<ItemStack> inv, int amount) {
            this(inv);
            this.binAmount = amount;
        }
    }
}

