/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public final class TransporterPathfinder {
    public static List<Destination> getPaths(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, int min) {
        ArrayList<Destination> paths = new ArrayList<Destination>();
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return paths;
        }
        List<InventoryNetwork.AcceptorData> acceptors = network.calculateAcceptors(request, stack.color);
        for (final InventoryNetwork.AcceptorData entry : acceptors) {
            Pathfinder.DestChecker checker = new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, EnumFacing dir, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, entry.response.stack, dir, false);
                }
            };
            Destination d = TransporterPathfinder.getPath(checker, entry.sides, start, entry.location, stack, entry.response, min);
            if (d == null) continue;
            paths.add(d);
        }
        Collections.sort(paths);
        return paths;
    }

    public static boolean checkPath(World world, List<Coord4D> path, TransporterStack stack) {
        for (int i = path.size() - 1; i > 0; --i) {
            TileEntity tile = path.get(i).getTileEntity((IBlockAccess)world);
            if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null)) {
                return false;
            }
            ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
            if (transporter != null && (transporter.getColor() == null || transporter.getColor() == stack.color)) continue;
            return false;
        }
        return true;
    }

    public static Destination getPath(Pathfinder.DestChecker checker, EnumSet<EnumFacing> sides, ILogisticalTransporter start, Coord4D dest, TransporterStack stack, TransitRequest.TransitResponse response, int min) {
        if (response.stack.func_190916_E() >= min) {
            List<Coord4D> test = PathfinderCache.getCache(start.coord(), dest, sides);
            if (test != null && TransporterPathfinder.checkPath(start.world(), test, stack)) {
                return new Destination(test, false, response, 0.0).calculateScore(start.world());
            }
            Pathfinder p = new Pathfinder(checker, start.world(), dest, start.coord(), stack);
            if (p.getPath().size() >= 2) {
                PathfinderCache.cachedPaths.put(new PathfinderCache.PathData(start.coord(), dest, p.side), p.getPath());
                return new Destination(p.getPath(), false, response, p.finalScore);
            }
        }
        return null;
    }

    public static Destination getNewBasePath(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    public static Destination getNewRRPath(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        HashMap<Coord4D, Destination> destPaths = new HashMap<Coord4D, Destination>();
        for (Destination d : paths) {
            if (destPaths.get(d.path.get(0)) != null && ((Destination)destPaths.get((Object)d.path.get((int)0))).path.size() >= d.path.size()) continue;
            destPaths.put(d.path.get(0), d);
        }
        ArrayList dests = new ArrayList();
        dests.addAll(destPaths.values());
        Collections.sort(dests);
        Destination closest = null;
        if (!dests.isEmpty()) {
            if (outputter.rrIndex <= dests.size() - 1) {
                closest = (Destination)dests.get(outputter.rrIndex);
                if (outputter.rrIndex == dests.size() - 1) {
                    outputter.rrIndex = 0;
                } else if (outputter.rrIndex < dests.size() - 1) {
                    ++outputter.rrIndex;
                }
            } else {
                closest = (Destination)dests.get(dests.size() - 1);
                outputter.rrIndex = 0;
            }
        }
        if (closest == null) {
            return null;
        }
        return closest;
    }

    public static Pair<List<Coord4D>, TransporterStack.Path> getIdlePath(ILogisticalTransporter start, TransporterStack stack) {
        IdlePath d;
        Destination dest;
        if (stack.homeLocation != null) {
            Pathfinder.DestChecker checker = new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, EnumFacing side, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            };
            Pathfinder p = new Pathfinder(checker, start.world(), stack.homeLocation, start.coord(), stack);
            ArrayList<Coord4D> path = p.getPath();
            if (path.size() >= 2) {
                return Pair.of(path, (Object)((Object)TransporterStack.Path.HOME));
            }
            stack.homeLocation = null;
        }
        if ((dest = (d = new IdlePath(start.world(), start.coord(), stack)).find()) == null) {
            return null;
        }
        return Pair.of(dest.path, (Object)((Object)dest.pathType));
    }

    public static class Pathfinder {
        public final Set<Coord4D> openSet;
        public final Set<Coord4D> closedSet;
        public final HashMap<Coord4D, Coord4D> navMap;
        public final HashMap<Coord4D, Double> gScore;
        public final HashMap<Coord4D, Double> fScore;
        public final Coord4D start;
        public final Coord4D finalNode;
        public final TransporterStack transportStack;
        public final DestChecker destChecker;
        public double finalScore;
        public EnumFacing side;
        public ArrayList<Coord4D> results;
        private World worldObj;

        public Pathfinder(DestChecker checker, World world, Coord4D finishObj, Coord4D startObj, TransporterStack stack) {
            this.destChecker = checker;
            this.worldObj = world;
            this.finalNode = finishObj;
            this.start = startObj;
            this.transportStack = stack;
            this.openSet = new HashSet<Coord4D>();
            this.closedSet = new HashSet<Coord4D>();
            this.navMap = new HashMap();
            this.gScore = new HashMap();
            this.fScore = new HashMap();
            this.results = new ArrayList();
            this.find(this.start);
        }

        public boolean find(Coord4D start) {
            this.openSet.add(start);
            this.gScore.put(start, 0.0);
            this.fScore.put(start, this.gScore.get(start) + this.getEstimate(start, this.finalNode));
            int blockCount = 0;
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                Coord4D neighbor = start.offset(direction);
                if (this.transportStack.canInsertToTransporter(neighbor.getTileEntity((IBlockAccess)this.worldObj), direction) || neighbor.equals(this.finalNode) && this.destChecker.isValid(this.transportStack, direction, neighbor.getTileEntity((IBlockAccess)this.worldObj))) continue;
                ++blockCount;
            }
            if (blockCount >= 6) {
                return false;
            }
            double maxSearchDistance = start.distanceTo(this.finalNode) * 2;
            ArrayList<EnumFacing> directionsToCheck = new ArrayList<EnumFacing>();
            Coord4D[] neighbors = new Coord4D[EnumFacing.field_82609_l.length];
            TileEntity[] neighborEntities = new TileEntity[neighbors.length];
            while (!this.openSet.isEmpty()) {
                Coord4D currentNode = null;
                double lowestFScore = 0.0;
                for (Coord4D node : this.openSet) {
                    if (currentNode != null && !(this.fScore.get(node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.get(node);
                }
                if (currentNode == null || (double)start.distanceTo(currentNode) > maxSearchDistance) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                TileEntity currentNodeTile = currentNode.getTileEntity((IBlockAccess)this.worldObj);
                ILogisticalTransporter currentNodeTransporter = null;
                if (currentNodeTile.hasCapability(Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null)) {
                    currentNodeTransporter = CapabilityUtils.getCapability((ICapabilityProvider)currentNodeTile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
                }
                directionsToCheck.clear();
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    TileEntity neighborEntity;
                    Coord4D neighbor;
                    neighbors[direction.ordinal()] = neighbor = currentNode.offset(direction);
                    neighborEntities[direction.ordinal()] = neighborEntity = neighbor.getTileEntity((IBlockAccess)this.worldObj);
                    if (currentNodeTransporter != null && !currentNodeTransporter.canEmitTo(neighborEntity, direction)) continue;
                    directionsToCheck.add(direction);
                }
                for (EnumFacing direction : directionsToCheck) {
                    Coord4D neighbor = neighbors[direction.ordinal()];
                    if (this.transportStack.canInsertToTransporter(neighborEntities[direction.ordinal()], direction)) {
                        TileEntity tile = neighborEntities[direction.ordinal()];
                        double tentativeG = this.gScore.get(currentNode) + CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, direction.func_176734_d()).getCost();
                        if (this.closedSet.contains(neighbor) && tentativeG >= this.gScore.get(neighbor) || this.openSet.contains(neighbor) && !(tentativeG < this.gScore.get(neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put(neighbor, tentativeG);
                        this.fScore.put(neighbor, this.gScore.get(neighbor) + this.getEstimate(neighbor, this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!neighbor.equals(this.finalNode) || !this.destChecker.isValid(this.transportStack, direction, neighborEntities[direction.ordinal()])) continue;
                    this.side = direction;
                    this.results = this.reconstructPath(this.navMap, currentNode);
                    return true;
                }
            }
            return false;
        }

        private ArrayList<Coord4D> reconstructPath(HashMap<Coord4D, Coord4D> naviMap, Coord4D currentNode) {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(currentNode);
            if (naviMap.containsKey(currentNode)) {
                path.addAll(this.reconstructPath(naviMap, naviMap.get(currentNode)));
            }
            this.finalScore = this.gScore.get(currentNode) + (double)currentNode.distanceTo(this.finalNode);
            return path;
        }

        public ArrayList<Coord4D> getPath() {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(this.finalNode);
            path.addAll(this.results);
            return path;
        }

        private double getEstimate(Coord4D start, Coord4D target2) {
            return start.distanceTo(target2);
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, EnumFacing side, TileEntity tile) {
                return false;
            }
        }
    }

    public static class Destination
    implements Comparable<Destination> {
        public List<Coord4D> path;
        public TransporterStack.Path pathType;
        public TransitRequest.TransitResponse response;
        public double score;

        public Destination(List<Coord4D> list, boolean inv, TransitRequest.TransitResponse ret, double gScore) {
            this.path = new ArrayList<Coord4D>(list);
            if (inv) {
                Collections.reverse(this.path);
            }
            this.response = ret;
            this.score = gScore;
        }

        public Destination setPathType(TransporterStack.Path type) {
            this.pathType = type;
            return this;
        }

        public Destination calculateScore(World world) {
            this.score = 0.0;
            for (Coord4D location : this.path) {
                TileEntity tile = location.getTileEntity((IBlockAccess)world);
                if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null)) continue;
                this.score += CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null).getCost();
            }
            return this;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            return code;
        }

        public boolean equals(Object dest) {
            return dest instanceof Destination && ((Destination)dest).path.equals(this.path);
        }

        @Override
        public int compareTo(Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return this.path.size() - dest.path.size();
        }
    }

    public static class IdlePath {
        public World worldObj;
        public Coord4D start;
        public TransporterStack transportStack;

        public IdlePath(World world, Coord4D obj, TransporterStack stack) {
            this.worldObj = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public Destination find() {
            ArrayList<Coord4D> ret = new ArrayList<Coord4D>();
            ret.add(this.start);
            if (this.transportStack.idleDir == null) {
                EnumFacing newSide = this.findSide();
                if (newSide == null) {
                    return null;
                }
                this.transportStack.idleDir = newSide;
                this.loopSide(ret, newSide);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TileEntity tile = this.start.offset(this.transportStack.idleDir).getTileEntity((IBlockAccess)this.worldObj);
            if (this.transportStack.canInsertToTransporter(tile, this.transportStack.idleDir)) {
                this.loopSide(ret, this.transportStack.idleDir);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TransitRequest request = TransitRequest.getFromTransport(this.transportStack);
            Destination newPath = TransporterPathfinder.getNewBasePath(CapabilityUtils.getCapability((ICapabilityProvider)this.start.getTileEntity((IBlockAccess)this.worldObj), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null), this.transportStack, request, 0);
            if (newPath != null && newPath.response != null) {
                this.transportStack.idleDir = null;
                newPath.setPathType(TransporterStack.Path.DEST);
                return newPath;
            }
            EnumFacing newSide = this.findSide();
            if (newSide == null) {
                return null;
            }
            this.transportStack.idleDir = newSide;
            this.loopSide(ret, newSide);
            return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
        }

        private void loopSide(List<Coord4D> list, EnumFacing side) {
            Coord4D coord;
            int count = 1;
            while (this.transportStack.canInsertToTransporter((coord = this.start.offset(side, count)).getTileEntity((IBlockAccess)this.worldObj), side)) {
                list.add(coord);
                ++count;
            }
        }

        private EnumFacing findSide() {
            if (this.transportStack.idleDir == null) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    TileEntity tile = this.start.offset(side).getTileEntity((IBlockAccess)this.worldObj);
                    if (!this.transportStack.canInsertToTransporter(tile, side)) continue;
                    return side;
                }
            } else {
                for (EnumFacing side : EnumSet.complementOf(EnumSet.of(this.transportStack.idleDir.func_176734_d()))) {
                    TileEntity tile = this.start.offset(side).getTileEntity((IBlockAccess)this.worldObj);
                    if (!this.transportStack.canInsertToTransporter(tile, side)) continue;
                    return side;
                }
                TileEntity tile = this.start.offset(this.transportStack.idleDir.func_176734_d()).getTileEntity((IBlockAccess)this.worldObj);
                if (this.transportStack.canInsertToTransporter(tile, this.transportStack.idleDir.func_176734_d())) {
                    return this.transportStack.idleDir.func_176734_d();
                }
            }
            return null;
        }
    }
}

