/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.enrichment")
@ModOnly(value="mtlib")
@ZenRegister
public class Enrichment {
    public static final String NAME = "Mekanism Enrichment Chamber";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IItemStack itemOutput) {
        if (itemInput == null || itemOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s recipe.", NAME));
            return;
        }
        EnrichmentRecipe recipe = new EnrichmentRecipe(InputHelper.toStack((IItemStack)itemInput), InputHelper.toStack((IItemStack)itemOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe(NAME, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemInput, @Optional IIngredient itemOutput) {
        if (itemInput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s recipe.", NAME));
        }
        if (itemOutput == null) {
            itemOutput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get(), itemInput, itemOutput));
    }

    private static class Remove
    extends RemoveMekanismRecipe {
        private IIngredient itemOutput;
        private IIngredient itemInput;

        public Remove(String name, Map<MachineInput, MachineRecipe> map, IIngredient itemInput, IIngredient itemOutput) {
            super(name, map);
            this.itemOutput = itemOutput;
            this.itemInput = itemInput;
        }

        @Override
        public void addRecipes() {
            HashMap recipesToRemove = new HashMap();
            for (Map.Entry entry : RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get().entrySet()) {
                IItemStack inputItem = InputHelper.toIItemStack((ItemStack)((ItemStackInput)entry.getKey()).ingredient);
                IItemStack outputItem = InputHelper.toIItemStack((ItemStack)((ItemStackOutput)((EnrichmentRecipe)entry.getValue()).recipeOutput).output);
                if (!StackHelper.matches((IIngredient)this.itemOutput, (IItemStack)outputItem) || !StackHelper.matches((IIngredient)this.itemInput, (IItemStack)inputItem)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logWarning((String)String.format("No %s recipe found for %s and %s. Command ignored!", Enrichment.NAME, this.itemInput.toString(), this.itemOutput.toString()));
            }
        }
    }
}

