/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.reaction")
@ModOnly(value="mtlib")
@ZenRegister
public class Reaction {
    public static final String NAME = "Mekanism Reaction";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, ILiquidStack liquidInput, IGasStack gasInput, IItemStack itemOutput, IGasStack gasOutput, double energy, int duration) {
        if (itemInput == null || liquidInput == null || gasInput == null || itemOutput == null || gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        PressurizedInput input = new PressurizedInput(InputHelper.toStack((IItemStack)itemInput), InputHelper.toFluid((ILiquidStack)liquidInput), GasHelper.toGas(gasInput));
        PressurizedOutput output = new PressurizedOutput(InputHelper.toStack((IItemStack)itemOutput), GasHelper.toGas(gasOutput));
        PressurizedRecipe recipe = new PressurizedRecipe(input, output, energy, duration);
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe(NAME, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, IIngredient gasOutput, @Optional IIngredient itemInput, @Optional IIngredient liquidInput, @Optional IIngredient gasInput) {
        if (itemOutput == null || gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        if (liquidInput == null) {
            liquidInput = IngredientAny.INSTANCE;
        }
        if (gasInput == null) {
            gasInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get(), itemOutput, gasOutput, itemInput, liquidInput, gasInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe {
        private IIngredient itemOutput;
        private IIngredient gasOutput;
        private IIngredient itemInput;
        private IIngredient liquidInput;
        private IIngredient gasInput;

        public Remove(String name, Map<MachineInput, MachineRecipe> map, IIngredient itemOutput, IIngredient gasOutput, IIngredient itemInput, IIngredient liquidInput, IIngredient gasInput) {
            super(name, map);
            this.itemOutput = itemOutput;
            this.gasOutput = gasOutput;
            this.itemInput = itemInput;
            this.liquidInput = liquidInput;
            this.gasInput = gasInput;
        }

        @Override
        public void addRecipes() {
            HashMap recipesToRemove = new HashMap();
            for (Map.Entry entry : RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get().entrySet()) {
                IItemStack inputItem = InputHelper.toIItemStack((ItemStack)((PressurizedInput)entry.getKey()).getSolid());
                ILiquidStack inputLiquid = InputHelper.toILiquidStack((FluidStack)((PressurizedInput)entry.getKey()).getFluid());
                CraftTweakerGasStack inputGas = new CraftTweakerGasStack(((PressurizedInput)entry.getKey()).getGas());
                IItemStack outputItem = InputHelper.toIItemStack((ItemStack)((PressurizedOutput)((PressurizedRecipe)entry.getValue()).recipeOutput).getItemOutput());
                CraftTweakerGasStack outputGas = new CraftTweakerGasStack(((PressurizedOutput)((PressurizedRecipe)entry.getValue()).recipeOutput).getGasOutput());
                if (!StackHelper.matches((IIngredient)this.itemInput, (IItemStack)inputItem) || !StackHelper.matches((IIngredient)this.liquidInput, (ILiquidStack)inputLiquid) || !GasHelper.matches(this.gasInput, inputGas) || !StackHelper.matches((IIngredient)this.itemOutput, (IItemStack)outputItem) || !GasHelper.matches(this.gasOutput, outputGas)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logWarning((String)String.format("No %s recipe found for %s, %s, %s, %s and %s. Command ignored!", Reaction.NAME, this.itemOutput.toString(), this.gasOutput.toString(), this.itemInput.toString(), this.liquidInput.toString(), this.gasInput.toString()));
            }
        }
    }
}

