/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.base.TileNetworkList;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLaserTractorBeam
extends TileEntityContainerBlock
implements ILaserReceptor,
ISecurityTile {
    public static final double MAX_ENERGY = 5.0E9;
    public double collectedEnergy = 0.0;
    public double lastFired = 0.0;
    public boolean on = false;
    public Coord4D digging;
    public double diggingProgress;
    public static int[] availableSlotIDs = InventoryUtils.getIntRange(0, 26);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityLaserTractorBeam() {
        super("LaserTractorBeam");
        this.inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void receiveLaserEnergy(double energy, EnumFacing side) {
        this.setEnergy(this.getEnergy() + energy);
    }

    @Override
    public boolean canLasersDig() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.on) {
                Coord4D hitCoord;
                RayTraceResult mop = LaserManager.fireLaserClient(this, this.facing, this.lastFired, this.field_145850_b);
                Coord4D coord4D = hitCoord = mop == null ? null : new Coord4D(mop, this.field_145850_b);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    IBlockState blockHit = hitCoord.getBlockState((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_185887_b(this.field_145850_b, hitCoord.getPos());
                    if (!(hardness < 0.0f || LaserManager.isReceptor(tileHit, mop.field_178784_b) && !LaserManager.getReceptor(tileHit, mop.field_178784_b).canLasersDig())) {
                        this.diggingProgress += this.lastFired;
                        if (this.diggingProgress < (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                            Mekanism.proxy.addHitEffects(hitCoord, mop);
                        }
                    }
                }
            }
        } else if (this.collectedEnergy > 0.0) {
            Coord4D hitCoord;
            double firing = this.collectedEnergy;
            if (!this.on || firing != this.lastFired) {
                this.on = true;
                this.lastFired = firing;
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), Coord4D.get(this).getTargetPoint(50.0));
            }
            LaserManager.LaserInfo info = LaserManager.fireLaser(this, this.facing, firing, this.field_145850_b);
            Coord4D coord4D = hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos, this.field_145850_b);
            if (hitCoord == null || !hitCoord.equals(this.digging)) {
                this.digging = hitCoord;
                this.diggingProgress = 0.0;
            }
            if (hitCoord != null) {
                IBlockState blockHit = hitCoord.getBlockState((IBlockAccess)this.field_145850_b);
                TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                float hardness = blockHit.func_185887_b(this.field_145850_b, hitCoord.getPos());
                if (!(hardness < 0.0f || LaserManager.isReceptor(tileHit, info.movingPos.field_178784_b) && !LaserManager.getReceptor(tileHit, info.movingPos.field_178784_b).canLasersDig())) {
                    this.diggingProgress += firing;
                    if (this.diggingProgress >= (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                        List<ItemStack> drops = LaserManager.breakBlock(hitCoord, false, this.field_145850_b);
                        if (drops != null) {
                            this.receiveDrops(drops);
                        }
                        this.diggingProgress = 0.0;
                    }
                }
            }
            this.setEnergy(this.getEnergy() - firing);
        } else if (this.on) {
            this.on = false;
            this.diggingProgress = 0.0;
            Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), Coord4D.get(this).getTargetPoint(50.0));
        }
    }

    public void setEnergy(double energy) {
        this.collectedEnergy = Math.max(0.0, Math.min(energy, 5.0E9));
    }

    public double getEnergy() {
        return this.collectedEnergy;
    }

    public void receiveDrops(List<ItemStack> drops) {
        block0: for (ItemStack drop : drops) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) {
                    this.inventory.set(i, (Object)drop);
                    continue block0;
                }
                ItemStack slot = (ItemStack)this.inventory.get(i);
                if (!StackUtils.equalsWildcardWithNBT(slot, drop)) continue;
                int change = Math.min(drop.func_190916_E(), slot.func_77976_d() - slot.func_190916_E());
                slot.func_190917_f(change);
                drop.func_190918_g(change);
                if (drop.func_190916_E() <= 0) continue block0;
            }
            this.dropItem(drop);
        }
    }

    public void dropItem(ItemStack stack) {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, stack);
        item.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = this.field_145850_b.field_73012_v.nextGaussian() * 0.05 + 0.2;
        item.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.05;
        item.func_174867_a(10);
        this.field_145850_b.func_72838_d((Entity)item);
    }

    @Override
    public boolean func_180462_a(int i, ItemStack itemStack, EnumFacing side) {
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return availableSlotIDs;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.on);
        data.add(this.collectedEnergy);
        data.add(this.lastFired);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.on = dataStream.readBoolean();
            this.collectedEnergy = dataStream.readDouble();
            this.lastFired = dataStream.readDouble();
        }
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.LASER_RECEPTOR_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.LASER_RECEPTOR_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }
}

