/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityThermalEvaporationValve
extends TileEntityThermalEvaporationBlock
implements IFluidHandlerWrapper,
IHeatTransfer {
    public boolean prevMaster = false;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.master == null == this.prevMaster) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    Coord4D obj = Coord4D.get(this).offset(side);
                    if (!obj.exists(this.field_145850_b) || obj.isAirBlock((IBlockAccess)this.field_145850_b) || obj.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock) continue;
                    MekanismUtils.notifyNeighborofChange(this.field_145850_b, obj, this.field_174879_c);
                }
            }
            this.prevMaster = this.master != null;
        }
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        TileEntityThermalEvaporationController controller = this.getController();
        return controller == null ? 0 : controller.inputTank.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller != null && (resource == null || resource.isFluidEqual(controller.outputTank.getFluid()))) {
            return controller.outputTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller != null) {
            return controller.outputTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        TileEntityThermalEvaporationController controller = this.getController();
        return controller != null && controller.hasRecipe(fluid);
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        TileEntityThermalEvaporationController controller = this.getController();
        return controller != null && controller.outputTank.getFluidAmount() > 0;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller == null) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)controller.inputTank), new FluidTankInfo((IFluidTank)controller.outputTank)};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public double getTemp() {
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return 0.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller != null) {
            controller.heatToAbsorb = (float)((double)controller.heatToAbsorb + heat);
        }
    }

    @Override
    public double[] simulateHeat() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double applyTemperatureChange() {
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return this.getController() != null;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getController() != null || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getController() != null) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }
}

