/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ILockableContainer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class InventoryUtils {
    public static final int[] EMPTY = new int[0];

    public static int[] getIntRange(int start, int end) {
        int[] ret = new int[1 + end - start];
        for (int i = start; i <= end; ++i) {
            ret[i - start] = i;
        }
        return ret;
    }

    public static IInventory checkChestInv(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest main = (TileEntityChest)inv;
            TileEntityChest adj = null;
            if (main.field_145991_k != null) {
                adj = main.field_145991_k;
            } else if (main.field_145990_j != null) {
                adj = main.field_145990_j;
            } else if (main.field_145992_i != null) {
                adj = main.field_145992_i;
            } else if (main.field_145988_l != null) {
                adj = main.field_145988_l;
            }
            if (adj != null) {
                return new InventoryLargeChest("", (ILockableContainer)main, (ILockableContainer)adj);
            }
        }
        return inv;
    }

    public static TransitRequest.TransitResponse putStackInInventory(TileEntity tile, TransitRequest request, EnumFacing side, boolean force) {
        if (force && tile instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tile).sendHome(request.getSingleStack());
        }
        for (Map.Entry<ItemStack, Integer> requestEntry : request.itemMap.entrySet()) {
            IInventory inventory;
            ItemStack toInsert = requestEntry.getKey().func_77946_l();
            if (tile instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)tile;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots != null && slots.length != 0) {
                    if (force && sidedInventory instanceof TileEntityBin && side == EnumFacing.UP) {
                        slots = sidedInventory.func_180463_a(EnumFacing.UP);
                    }
                    for (int get = 0; get <= slots.length - 1; ++get) {
                        ItemStack toSet;
                        int slotID = slots[get];
                        if (!force && (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d()))) continue;
                        ItemStack inSlot = sidedInventory.func_70301_a(slotID);
                        if (inSlot.func_190926_b()) {
                            if (toInsert.func_190916_E() <= sidedInventory.func_70297_j_()) {
                                sidedInventory.func_70299_a(slotID, toInsert);
                                sidedInventory.func_70296_d();
                                return new TransitRequest.TransitResponse(requestEntry.getValue(), requestEntry.getKey());
                            }
                            int rejects = toInsert.func_190916_E() - sidedInventory.func_70297_j_();
                            toSet = toInsert.func_77946_l();
                            toSet.func_190920_e(sidedInventory.func_70297_j_());
                            ItemStack remains = toInsert.func_77946_l();
                            remains.func_190920_e(rejects);
                            sidedInventory.func_70299_a(slotID, toSet);
                            sidedInventory.func_70296_d();
                            toInsert = remains;
                            continue;
                        }
                        if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_())) continue;
                        int max = Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_());
                        if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                            toSet = toInsert.func_77946_l();
                            toSet.func_190917_f(inSlot.func_190916_E());
                            sidedInventory.func_70299_a(slotID, toSet);
                            sidedInventory.func_70296_d();
                            return new TransitRequest.TransitResponse(requestEntry.getValue(), requestEntry.getKey());
                        }
                        int rejects = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                        ItemStack toSet2 = toInsert.func_77946_l();
                        toSet2.func_190920_e(max);
                        ItemStack remains = toInsert.func_77946_l();
                        remains.func_190920_e(rejects);
                        sidedInventory.func_70299_a(slotID, toSet2);
                        sidedInventory.func_70296_d();
                        toInsert = remains;
                    }
                }
            } else if (tile instanceof IInventory) {
                inventory = InventoryUtils.checkChestInv((IInventory)tile);
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!force && !inventory.func_94041_b(i, toInsert)) continue;
                    ItemStack inSlot = inventory.func_70301_a(i);
                    if (inSlot.func_190926_b()) {
                        if (toInsert.func_190916_E() <= inventory.func_70297_j_()) {
                            inventory.func_70299_a(i, toInsert);
                            inventory.func_70296_d();
                            return new TransitRequest.TransitResponse(requestEntry.getValue(), requestEntry.getKey());
                        }
                        int rejects = toInsert.func_190916_E() - inventory.func_70297_j_();
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.func_190920_e(inventory.func_70297_j_());
                        ItemStack remains = toInsert.func_77946_l();
                        remains.func_190920_e(rejects);
                        inventory.func_70299_a(i, toSet);
                        inventory.func_70296_d();
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), inventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
                    if (inSlot.func_190916_E() + toInsert.func_190916_E() <= max) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.func_190917_f(inSlot.func_190916_E());
                        inventory.func_70299_a(i, toSet);
                        inventory.func_70296_d();
                        return new TransitRequest.TransitResponse(requestEntry.getValue(), requestEntry.getKey());
                    }
                    int rejects = inSlot.func_190916_E() + toInsert.func_190916_E() - max;
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.func_190920_e(max);
                    ItemStack remains = toInsert.func_77946_l();
                    remains.func_190920_e(rejects);
                    inventory.func_70299_a(i, toSet);
                    inventory.func_70296_d();
                    toInsert = remains;
                }
            } else if (InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
                inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    if (!(toInsert = inventory.insertItem(i, toInsert, false)).func_190926_b()) continue;
                    return new TransitRequest.TransitResponse(requestEntry.getValue(), requestEntry.getKey());
                }
            }
            if (!TransporterManager.didEmit(requestEntry.getKey(), toInsert)) continue;
            return new TransitRequest.TransitResponse(requestEntry.getValue(), TransporterManager.getToUse(requestEntry.getKey(), toInsert));
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.func_190926_b() || inSlot.func_190926_b()) {
            return true;
        }
        return inSlot.func_77969_a(toInsert) && ItemStack.func_77970_a((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static InvStack takeDefinedItem(TileEntity tile, EnumFacing side, ItemStack type, int min, int max) {
        InvStack ret = new InvStack(tile, side.func_176734_d());
        if (InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
            IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
            for (int i = inventory.getSlots() - 1; i >= 0; --i) {
                int current;
                ItemStack stack = inventory.extractItem(i, max, true);
                if (stack.func_190926_b() || !StackUtils.equalsWildcard(stack, type)) continue;
                int n = current = !ret.getStack().func_190926_b() ? ret.getStack().func_190916_E() : 0;
                if (current + stack.func_190916_E() <= max) {
                    ret.appendStack(i, stack.func_77946_l());
                } else {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(max - current);
                    ret.appendStack(i, copy);
                }
                if (ret.getStack().func_190926_b() || ret.getStack().func_190916_E() != max) continue;
                return ret;
            }
        } else if (tile instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)tile;
            int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
            if (slots != null && slots.length != 0) {
                for (int get = slots.length - 1; get >= 0; --get) {
                    ItemStack copy;
                    int current;
                    int slotID = slots[get];
                    if (sidedInventory.func_70301_a(slotID).func_190926_b() || !StackUtils.equalsWildcard(sidedInventory.func_70301_a(slotID), type)) continue;
                    ItemStack stack = sidedInventory.func_70301_a(slotID);
                    int n = current = !ret.getStack().func_190926_b() ? ret.getStack().func_190916_E() : 0;
                    if (current + stack.func_190916_E() <= max) {
                        copy = stack.func_77946_l();
                        if (sidedInventory.func_180461_b(slotID, copy, side.func_176734_d())) {
                            ret.appendStack(slotID, copy);
                        }
                    } else {
                        copy = stack.func_77946_l();
                        if (sidedInventory.func_180461_b(slotID, copy, side.func_176734_d())) {
                            copy.func_190920_e(max - current);
                            ret.appendStack(slotID, copy);
                        }
                    }
                    if (ret.getStack().func_190926_b() || ret.getStack().func_190916_E() != max) continue;
                    return ret;
                }
            }
        } else if (tile instanceof IInventory) {
            IInventory inventory = InventoryUtils.checkChestInv((IInventory)tile);
            for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                int current;
                if (inventory.func_70301_a(i).func_190926_b() || !StackUtils.equalsWildcard(inventory.func_70301_a(i), type)) continue;
                ItemStack stack = inventory.func_70301_a(i);
                int n = current = !ret.getStack().func_190926_b() ? ret.getStack().func_190916_E() : 0;
                if (current + stack.func_190916_E() <= max) {
                    ret.appendStack(i, stack.func_77946_l());
                } else {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(max - current);
                    ret.appendStack(i, copy);
                }
                if (ret.getStack().func_190926_b() || ret.getStack().func_190916_E() != max) continue;
                return ret;
            }
        }
        if (ret != null && !ret.getStack().func_190926_b() && ret.getStack().func_190916_E() >= min) {
            return ret;
        }
        return null;
    }

    public static boolean canInsert(TileEntity tileEntity, EnumColor color, ItemStack itemStack, EnumFacing side, boolean force) {
        block15: {
            IItemHandler inventory;
            block16: {
                block14: {
                    if (force && tileEntity instanceof TileEntityLogisticalSorter) {
                        return ((TileEntityLogisticalSorter)tileEntity).canSendHome(itemStack);
                    }
                    if (!force && tileEntity instanceof ISideConfiguration) {
                        ISideConfiguration config = (ISideConfiguration)tileEntity;
                        EnumFacing tileSide = config.getOrientation();
                        EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
                        if (config.getEjector().hasStrictInput() && configColor != null && configColor != color) {
                            return false;
                        }
                    }
                    if (!InventoryUtils.isItemHandler(tileEntity, side.func_176734_d())) break block14;
                    inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
                    for (int i = 0; i < inventory.getSlots(); ++i) {
                        ItemStack rejects = inventory.insertItem(i, itemStack, true);
                        if (!TransporterManager.didEmit(itemStack, rejects)) continue;
                        return true;
                    }
                    break block15;
                }
                if (!(tileEntity instanceof ISidedInventory)) break block16;
                ISidedInventory sidedInventory = (ISidedInventory)tileEntity;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots == null || slots.length == 0) break block15;
                if (force && sidedInventory instanceof TileEntityBin && side == EnumFacing.UP) {
                    slots = sidedInventory.func_180463_a(EnumFacing.UP);
                }
                for (int get = 0; get <= slots.length - 1; ++get) {
                    int slotID = slots[get];
                    if (!force && (!sidedInventory.func_94041_b(slotID, itemStack) || !sidedInventory.func_180462_a(slotID, itemStack, side.func_176734_d()))) continue;
                    ItemStack inSlot = sidedInventory.func_70301_a(slotID);
                    if (inSlot.func_190926_b()) {
                        if (itemStack.func_190916_E() <= sidedInventory.func_70297_j_()) {
                            return true;
                        }
                        int rejects = itemStack.func_190916_E() - sidedInventory.func_70297_j_();
                        if (rejects >= itemStack.func_190916_E()) continue;
                        return true;
                    }
                    if (!InventoryUtils.areItemsStackable(itemStack, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_());
                    if (inSlot.func_190916_E() + itemStack.func_190916_E() <= max) {
                        return true;
                    }
                    int rejects = inSlot.func_190916_E() + itemStack.func_190916_E() - max;
                    if (rejects >= itemStack.func_190916_E()) continue;
                    return true;
                }
                break block15;
            }
            if (tileEntity instanceof IInventory) {
                inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!force && !inventory.func_94041_b(i, itemStack)) continue;
                    ItemStack inSlot = inventory.func_70301_a(i);
                    if (inSlot.func_190926_b()) {
                        if (itemStack.func_190916_E() <= inventory.func_70297_j_()) {
                            return true;
                        }
                        int rejects = itemStack.func_190916_E() - inventory.func_70297_j_();
                        if (rejects >= itemStack.func_190916_E()) continue;
                        return true;
                    }
                    if (!InventoryUtils.areItemsStackable(itemStack, inSlot) || inSlot.func_190916_E() >= Math.min(inSlot.func_77976_d(), inventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
                    if (inSlot.func_190916_E() + itemStack.func_190916_E() <= max) {
                        return true;
                    }
                    int rejects = inSlot.func_190916_E() + itemStack.func_190916_E() - max;
                    if (rejects >= itemStack.func_190916_E()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTags) {
        ItemStack ret = new ItemStack(nbtTags);
        return ret;
    }

    public static boolean isItemHandler(TileEntity tile, EnumFacing side) {
        return CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        return (IItemHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77952_i() == stack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && stack1.func_77985_e();
    }
}

