/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.core.ItemHandlerBlockWrapper;
import org.cyclops.integratedtunnels.core.ItemStackPredicate;

public class TunnelItemHelpers {
    public static final ItemStackPredicate MATCH_ALL = new ItemStackPredicate(ItemStack.field_190927_a, 0){

        @Override
        public boolean test(@Nullable ItemStack input) {
            return true;
        }
    };
    public static final ItemStackPredicate MATCH_NONE = new ItemStackPredicate(ItemStack.field_190927_a, 7){

        @Override
        public boolean test(@Nullable ItemStack input) {
            return false;
        }
    };
    public static final ItemStackPredicate MATCH_BLOCK = new ItemStackPredicate(){

        @Override
        public boolean test(@Nullable ItemStack input) {
            return !input.func_190926_b();
        }
    };
    private static final Cache<Integer, Integer> CACHE_INV_STATES = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Cache<Integer, Boolean> CACHE_INV_CHECKS = CacheBuilder.newBuilder().expireAfterWrite((long)(GeneralConfig.inventoryUnchangedTickTimeout * 50), TimeUnit.MILLISECONDS).build();

    @Nonnull
    public static ItemStack moveItemsSingle(IItemHandler source, int sourceSlot, @Nullable ISlotlessItemHandler sourceSlotless, IItemHandler target, int targetSlot, @Nullable ISlotlessItemHandler targetSlotless, int amount, ItemStackPredicate itemStackMatcher, boolean simulate) {
        block15: {
            boolean loopTargetSlots;
            block16: {
                boolean loopSourceSlots;
                block14: {
                    ItemStack extracted;
                    if (sourceSlot >= source.getSlots() || targetSlot >= target.getSlots()) {
                        return ItemStack.field_190927_a;
                    }
                    loopSourceSlots = sourceSlot < 0;
                    boolean bl = loopTargetSlots = targetSlot < 0;
                    if (loopSourceSlots && (sourceSlotless == null || !itemStackMatcher.hasMatchFlags()) || loopTargetSlots && targetSlotless == null) break block14;
                    boolean appliedMatcher = false;
                    if (loopSourceSlots && itemStackMatcher.hasMatchFlags()) {
                        if (itemStackMatcher.getItemStack().func_190926_b()) {
                            extracted = sourceSlotless.extractItem(amount, simulate);
                            appliedMatcher = true;
                        } else {
                            ItemStack itemStack = itemStackMatcher.getItemStack();
                            if (!itemStack.func_190926_b() && itemStack.func_190916_E() != amount) {
                                itemStack = itemStack.func_77946_l();
                                itemStack.func_190920_e(amount);
                            }
                            extracted = sourceSlotless.extractItem(itemStack, itemStackMatcher.getMatchFlags(), simulate);
                            appliedMatcher = true;
                        }
                    } else {
                        extracted = source.extractItem(sourceSlot, amount, simulate);
                    }
                    if (!extracted.func_190926_b() && (!simulate || appliedMatcher || itemStackMatcher.test(extracted))) {
                        ItemStack remaining;
                        ItemStack itemStack = remaining = !loopTargetSlots ? target.insertItem(targetSlot, extracted, simulate) : targetSlotless.insertItem(extracted, simulate);
                        if (remaining.func_190926_b()) {
                            return extracted;
                        }
                        extracted = extracted.func_77946_l();
                        extracted.func_190918_g(remaining.func_190916_E());
                        if (!simulate) {
                            ItemStack itemStack2 = remaining = loopSourceSlots ? sourceSlotless.insertItem(remaining, false) : source.insertItem(sourceSlot, remaining, false);
                            if (!remaining.func_190926_b()) {
                                IntegratedTunnels.clog(Level.WARN, "Just lost stack " + remaining + " while transfering items, report this to the Integrated Tunnels issue tracker with some details about your setup!");
                            }
                        }
                        return extracted.func_190916_E() > 0 && (simulate || itemStackMatcher.test(extracted)) ? extracted : ItemStack.field_190927_a;
                    }
                    break block15;
                }
                if (!loopSourceSlots) break block16;
                for (sourceSlot = 0; sourceSlot < source.getSlots(); ++sourceSlot) {
                    ItemStack moved;
                    ItemStack movedSimulated;
                    if (loopTargetSlots) {
                        if (source.getStackInSlot(sourceSlot).func_190926_b()) continue;
                        for (targetSlot = 0; targetSlot < target.getSlots(); ++targetSlot) {
                            if (!simulate && (movedSimulated = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, true)).func_190926_b() || (moved = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, simulate)).func_190926_b()) continue;
                            return moved;
                        }
                        continue;
                    }
                    if (!simulate && (movedSimulated = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, true)).func_190926_b() || (moved = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, simulate)).func_190926_b()) continue;
                    return moved;
                }
                break block15;
            }
            if (!loopTargetSlots) break block15;
            for (targetSlot = 0; targetSlot < target.getSlots(); ++targetSlot) {
                ItemStack moved;
                ItemStack movedSimulated;
                if (!simulate && (movedSimulated = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, true)).func_190926_b() || (moved = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, simulate)).func_190926_b()) continue;
                return moved;
            }
        }
        return ItemStack.field_190927_a;
    }

    protected static Integer getCachedState(int posHash) {
        return (Integer)CACHE_INV_STATES.getIfPresent((Object)posHash);
    }

    protected static void setCachedState(int posHash, int state) {
        CACHE_INV_STATES.put((Object)posHash, (Object)state);
        CACHE_INV_CHECKS.put((Object)posHash, (Object)true);
    }

    protected static boolean shouldCheckState(int posHash) {
        return CACHE_INV_CHECKS.getIfPresent((Object)posHash) == null;
    }

    protected static void invalidateCachedState(int posHash) {
        CACHE_INV_STATES.invalidate((Object)posHash);
        CACHE_INV_CHECKS.invalidate((Object)posHash);
    }

    public static int calculateInventoryState(IItemHandler itemHandler, @Nullable IInventoryState inventoryState) {
        if (inventoryState != null) {
            return inventoryState.getHash();
        }
        int hash = itemHandler.hashCode();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            hash += ItemStackHelpers.getItemStackHashCode((ItemStack)itemHandler.getStackInSlot(i)) << i % 100;
        }
        return hash;
    }

    @Nonnull
    public static ItemStack moveItems(IItemHandler source, int sourceSlot, @Nullable ISlotlessItemHandler sourceSlotless, IItemHandler target, int targetSlot, @Nullable ISlotlessItemHandler targetSlotless, int amount) {
        ItemStack simulatedTransfer = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, MATCH_ALL, true);
        if (simulatedTransfer.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, simulatedTransfer.func_190916_E(), MATCH_ALL, false);
    }

    @Nonnull
    public static ItemStack moveItemsStateOptimized(int connectionHash, IItemHandler sourceHandler, @Nullable IInventoryState sourceInvState, int sourceSlot, @Nullable ISlotlessItemHandler sourceSlotless, IItemHandler targetHandler, @Nullable IInventoryState targetInvState, int targetSlot, @Nullable ISlotlessItemHandler targetSlotless, int amount, ItemStackPredicate itemStackMatcher) {
        boolean shouldMoveItems;
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        Integer cachedState = TunnelItemHelpers.getCachedState(connectionHash);
        boolean calculatedStates = false;
        int currentState = 0;
        boolean bl = shouldMoveItems = cachedState == null;
        if (!shouldMoveItems && TunnelItemHelpers.shouldCheckState(connectionHash)) {
            calculatedStates = true;
            currentState = TunnelItemHelpers.calculateInventoryState(sourceHandler, sourceInvState) + TunnelItemHelpers.calculateInventoryState(targetHandler, targetInvState);
            boolean bl2 = shouldMoveItems = cachedState != currentState;
            if (!shouldMoveItems) {
                CACHE_INV_CHECKS.put((Object)connectionHash, (Object)true);
            }
        }
        if (shouldMoveItems) {
            ItemStack simulatedTransfer = TunnelItemHelpers.moveItemsSingle(sourceHandler, sourceSlot, sourceSlotless, targetHandler, targetSlot, targetSlotless, amount, itemStackMatcher, true);
            if (simulatedTransfer.func_190926_b()) {
                if (!calculatedStates) {
                    currentState = TunnelItemHelpers.calculateInventoryState(sourceHandler, sourceInvState) + TunnelItemHelpers.calculateInventoryState(targetHandler, targetInvState);
                }
                TunnelItemHelpers.setCachedState(connectionHash, currentState);
                return ItemStack.field_190927_a;
            }
            TunnelItemHelpers.invalidateCachedState(connectionHash);
            return TunnelItemHelpers.moveItemsSingle(sourceHandler, sourceSlot, sourceSlotless, targetHandler, targetSlot, targetSlotless, simulatedTransfer.func_190916_E(), itemStackMatcher, false);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStackPredicate matchItemStack(final ItemStack itemStack, final boolean checkStackSize, final boolean checkDamage, final boolean checkNbt) {
        int matchFlags = 0;
        if (checkDamage) {
            matchFlags |= 1;
        }
        if (checkNbt) {
            matchFlags |= 2;
        }
        if (checkStackSize) {
            matchFlags |= 4;
        }
        return new ItemStackPredicate(itemStack.func_77946_l(), matchFlags){

            @Override
            public boolean test(@Nullable ItemStack input) {
                return TunnelItemHelpers.areItemStackEqual(input, itemStack, checkStackSize, true, checkDamage, checkNbt);
            }
        };
    }

    public static ItemStackPredicate matchItemStacks(final IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack> itemStacks, final boolean checkStackSize, final boolean checkDamage, final boolean checkNbt, final boolean blacklist) {
        return new ItemStackPredicate(){

            @Override
            public boolean test(@Nullable ItemStack input) {
                for (ValueObjectTypeItemStack.ValueItemStack itemStack : itemStacks) {
                    if (itemStack.getRawValue().func_190926_b() || !TunnelItemHelpers.areItemStackEqual(input, itemStack.getRawValue(), checkStackSize, true, checkDamage, checkNbt)) continue;
                    return !blacklist;
                }
                return blacklist;
            }
        };
    }

    public static ItemStackPredicate matchPredicateItem(final PartTarget partTarget, final IOperator predicate) {
        return new ItemStackPredicate(){

            @Override
            public boolean test(@Nullable ItemStack input) {
                ValueObjectTypeItemStack.ValueItemStack valueItemStack = ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)input);
                try {
                    IValue result = ValueHelpers.evaluateOperator((IOperator)predicate, (IValue[])new IValue[]{valueItemStack});
                    return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
                }
                catch (EvaluationException e) {
                    PartHelpers.PartStateHolder partData = PartHelpers.getPart((PartPos)partTarget.getCenter());
                    if (partData != null) {
                        IPartStateWriter partState = (IPartStateWriter)partData.getState();
                        partState.addError(partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                        partState.setDeactivated(true);
                    }
                    return false;
                }
            }
        };
    }

    public static ItemStackPredicate matchBlocks(final IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock> blocks, final boolean checkStackSize, final boolean checkDamage, final boolean checkNbt, final boolean blacklist) {
        return new ItemStackPredicate(){

            @Override
            public boolean test(@Nullable ItemStack input) {
                for (ValueObjectTypeBlock.ValueBlock block : blocks) {
                    if (block.getRawValue().isPresent() || !TunnelItemHelpers.areItemStackEqual(input, BlockHelpers.getItemStackFromBlockState((IBlockState)((IBlockState)block.getRawValue().get())), checkStackSize, true, checkDamage, checkNbt)) continue;
                    return !blacklist;
                }
                return blacklist;
            }
        };
    }

    public static ItemStackPredicate matchPredicateBlock(final PartTarget partTarget, final IOperator predicate) {
        return new ItemStackPredicate(){

            @Override
            public boolean test(@Nullable ItemStack input) {
                ValueObjectTypeBlock.ValueBlock valueBlock = ValueObjectTypeBlock.ValueBlock.of((IBlockState)(input.func_77973_b() instanceof ItemBlock ? BlockHelpers.getBlockStateFromItemStack((ItemStack)input) : null));
                try {
                    IValue result = ValueHelpers.evaluateOperator((IOperator)predicate, (IValue[])new IValue[]{valueBlock});
                    return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
                }
                catch (EvaluationException e) {
                    PartHelpers.PartStateHolder partData = PartHelpers.getPart((PartPos)partTarget.getCenter());
                    if (partData != null) {
                        IPartStateWriter partState = (IPartStateWriter)partData.getState();
                        partState.addError(partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                        partState.setDeactivated(true);
                    }
                    return false;
                }
            }
        };
    }

    public static boolean areItemStackEqual(ItemStack stackA, ItemStack stackB, boolean checkStackSize, boolean checkItem, boolean checkDamage, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkStackSize && stackA.func_190916_E() != stackB.func_190916_E()) {
                return false;
            }
            if (checkItem && stackA.func_77973_b() != stackB.func_77973_b()) {
                return false;
            }
            if (checkDamage && stackA.func_77952_i() != stackB.func_77952_i()) {
                return false;
            }
            return !checkNbt || ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
        }
        return false;
    }

    public static ItemStack placeItems(int connectionHash, IItemHandler sourceHandler, @Nullable IInventoryState sourceInvState, @Nullable ISlotlessItemHandler sourceSlotless, World world, BlockPos pos, EnumFacing side, ItemStackPredicate itemStackMatcher, EnumHand hand, boolean blockUpdate, boolean ignoreReplacable) {
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || isDestNonSolid && ignoreReplacable && isDestReplaceable)) {
            return null;
        }
        ItemHandlerBlockWrapper targetBlock = new ItemHandlerBlockWrapper(true, (WorldServer)world, pos, side, hand, blockUpdate, 0, false, ignoreReplacable, true);
        return TunnelItemHelpers.moveItemsStateOptimized(connectionHash, sourceHandler, sourceInvState, -1, sourceSlotless, targetBlock, null, 0, null, 1, itemStackMatcher);
    }

    public static List<ItemStack> pickUpItems(int connectionHash, World world, BlockPos pos, EnumFacing side, IItemHandler targetHandler, @Nullable IInventoryState targetInvState, @Nullable ISlotlessItemHandler targetSlotless, ItemStackPredicate itemStackMatcher, EnumHand hand, boolean blockUpdate, boolean ignoreReplacable, int fortune, boolean silkTouch, boolean breakOnNoDrops) {
        ItemStack itemStack;
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (world.func_175623_d(pos) || ignoreReplacable && isDestReplaceable || destMaterial.func_76224_d()) {
            return null;
        }
        ItemHandlerBlockWrapper sourceBlock = new ItemHandlerBlockWrapper(false, (WorldServer)world, pos, side, hand, blockUpdate, fortune, silkTouch, ignoreReplacable, breakOnNoDrops);
        ArrayList itemStacks = Lists.newArrayList();
        while (!(itemStack = TunnelItemHelpers.moveItemsStateOptimized(connectionHash, sourceBlock, null, -1, null, targetHandler, targetInvState, -1, targetSlotless, Integer.MAX_VALUE, itemStackMatcher)).func_190926_b()) {
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }
}

