/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.network;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.integrateddynamics.api.network.IChanneledNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.core.network.ItemNetwork;

public class ItemChannel
implements IItemNetwork.IItemChannel {
    final ItemNetwork network;
    final int channel;

    ItemChannel(ItemNetwork network, int channel) {
        this.network = network;
        this.channel = channel;
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            ISlotlessItemHandler itemHandler;
            if (!IChanneledNetwork.channelsMatch((int)partPos.getChannel(), (int)this.channel) || (itemHandler = this.network.getSlotlessItemHandler(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            stack = itemHandler.insertItem(stack, simulate);
            this.network.enablePosition(partPos.getPartPos());
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack extractItem(int amount, boolean simulate) {
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            ISlotlessItemHandler itemHandler;
            if (!IChanneledNetwork.channelsMatch((int)partPos.getChannel(), (int)this.channel) || (itemHandler = this.network.getSlotlessItemHandler(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            ItemStack extracted = itemHandler.extractItem(amount, simulate);
            this.network.enablePosition(partPos.getPartPos());
            if (extracted.func_190926_b()) continue;
            return extracted;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(ItemStack matchStack, int matchFlags, boolean simulate) {
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            ISlotlessItemHandler itemHandler;
            if (!IChanneledNetwork.channelsMatch((int)partPos.getChannel(), (int)this.channel) || (itemHandler = this.network.getSlotlessItemHandler(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            ItemStack extracted = itemHandler.extractItem(matchStack, matchFlags, simulate);
            this.network.enablePosition(partPos.getPartPos());
            if (extracted.func_190926_b()) continue;
            return extracted;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlots() {
        int slots = 0;
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            IItemHandler itemHandler;
            if (!IChanneledNetwork.channelsMatch((int)partPos.getChannel(), (int)this.channel) || (itemHandler = this.network.getItemHandler(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            slots += itemHandler.getSlots();
            this.network.enablePosition(partPos.getPartPos());
        }
        return slots;
    }

    protected Triple<IItemHandler, Integer, IPositionedAddonsNetwork.PrioritizedPartPos> getItemHandlerForSlot(int slot) {
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            IItemHandler itemHandler;
            if (!IChanneledNetwork.channelsMatch((int)partPos.getChannel(), (int)this.channel) || (itemHandler = this.network.getItemHandler(partPos)) == null) continue;
            int slots = itemHandler.getSlots();
            if (slot < slots) {
                return Triple.of((Object)itemHandler, (Object)slot, (Object)partPos);
            }
            slot -= slots;
        }
        return null;
    }

    public ItemStack getStackInSlot(int slot) {
        Triple<IItemHandler, Integer, IPositionedAddonsNetwork.PrioritizedPartPos> slottedHandler = this.getItemHandlerForSlot(slot);
        if (slottedHandler != null) {
            this.network.disablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            ItemStack ret = ((IItemHandler)slottedHandler.getLeft()).getStackInSlot(((Integer)slottedHandler.getMiddle()).intValue());
            this.network.enablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Triple<IItemHandler, Integer, IPositionedAddonsNetwork.PrioritizedPartPos> slottedHandler = this.getItemHandlerForSlot(slot);
        if (slottedHandler != null) {
            this.network.disablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            ItemStack ret = ((IItemHandler)slottedHandler.getLeft()).insertItem(((Integer)slottedHandler.getMiddle()).intValue(), stack, simulate);
            this.network.enablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            return ret;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Triple<IItemHandler, Integer, IPositionedAddonsNetwork.PrioritizedPartPos> slottedHandler = this.getItemHandlerForSlot(slot);
        if (slottedHandler != null) {
            this.network.disablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            ItemStack ret = ((IItemHandler)slottedHandler.getLeft()).extractItem(((Integer)slottedHandler.getMiddle()).intValue(), amount, simulate);
            this.network.enablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        Triple<IItemHandler, Integer, IPositionedAddonsNetwork.PrioritizedPartPos> slottedHandler = this.getItemHandlerForSlot(slot);
        if (slottedHandler != null) {
            this.network.disablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            int ret = ((IItemHandler)slottedHandler.getLeft()).getSlotLimit(((Integer)slottedHandler.getMiddle()).intValue());
            this.network.enablePosition(((IPositionedAddonsNetwork.PrioritizedPartPos)slottedHandler.getRight()).getPartPos());
            return ret;
        }
        return 0;
    }
}

