/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteActivator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteDeactivator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.capability.network.ItemNetworkConfig;
import org.cyclops.integratedtunnels.core.ItemHandlerPlayerWrapper;
import org.cyclops.integratedtunnels.core.ItemHandlerWorldEntityExportWrapper;
import org.cyclops.integratedtunnels.core.ItemHandlerWorldEntityImportWrapper;
import org.cyclops.integratedtunnels.core.ItemStackPredicate;
import org.cyclops.integratedtunnels.core.TunnelEnergyHelpers;
import org.cyclops.integratedtunnels.core.TunnelFluidHelpers;
import org.cyclops.integratedtunnels.core.TunnelItemHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;
import org.cyclops.integratedtunnels.part.PartStatePlayerSimulator;

public class TunnelAspectWriteBuilders {
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_BLACKLIST = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.blacklist.name");
    public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_CHANNEL = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.channel.name");
    public static final IAspectProperties PROPERTIES_CHANNEL = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL));

    public static <N extends IPositionedAddonsNetwork, T> IAspectWriteActivator createPositionedNetworkAddonActivator(final Supplier<Capability<N>> networkCapability, final Capability<T> targetCapability) {
        return new IAspectWriteActivator(){

            public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
                state.addVolatileCapability(targetCapability, state);
                DimPos pos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getWorld(), (BlockPos)pos.getBlockPos());
                if (network != null && network.hasCapability((Capability)networkCapability.get())) {
                    ((PartStatePositionedAddon)state).setPositionedAddonsNetwork((IPositionedAddonsNetwork)network.getCapability((Capability)networkCapability.get()));
                    DimPos originPos = target.getCenter().getPos();
                    DimPos targetPos = target.getTarget().getPos();
                    targetPos.getWorld().func_190524_a(targetPos.getBlockPos(), targetPos.getWorld().func_180495_p(targetPos.getBlockPos()).func_177230_c(), originPos.getBlockPos());
                }
            }
        };
    }

    public static <N extends IPositionedAddonsNetwork, T> IAspectWriteDeactivator createPositionedNetworkAddonDeactivator(final Supplier<Capability<N>> networkCapability, final Capability<T> targetCapability) {
        return new IAspectWriteDeactivator(){

            public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
                state.removeVolatileCapability(targetCapability);
                DimPos pos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getWorld(), (BlockPos)pos.getBlockPos());
                if (network != null && network.hasCapability((Capability)networkCapability.get())) {
                    ((PartStatePositionedAddon)state).setPositionedAddonsNetwork((IPositionedAddonsNetwork)network.getCapability((Capability)networkCapability.get()));
                    DimPos originPos = target.getCenter().getPos();
                    DimPos targetPos = target.getTarget().getPos();
                    targetPos.getWorld().func_190524_a(targetPos.getBlockPos(), targetPos.getWorld().func_180495_p(targetPos.getBlockPos()).func_177230_c(), originPos.getBlockPos());
                }
            }
        };
    }

    public static INetwork getNetworkChecked(PartPos pos) throws PartStateException {
        INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getPos().getWorld(), (BlockPos)pos.getPos().getBlockPos());
        if (network == null) {
            IntegratedDynamics.clog((Level)Level.ERROR, (String)"Could not get the energy network as no network was found.");
            throw new PartStateException(pos.getPos(), pos.getSide());
        }
        return network;
    }

    static {
        PROPERTIES_CHANNEL.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
    }

    public static final class Player {
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").withProperties(PROPERTIES_CHANNEL);
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_RIGHT_CLICK = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.player.rightclick.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CONTINUOUS_CLICK = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.player.continuousclick.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_SNEAK = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.player.sneak.name");
        public static final IAspectProperties PROPERTIES_CLICK_EMPTY = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RIGHT_CLICK, World.PROP_HAND_LEFT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z));
        public static final IAspectProperties PROPERTIES_CLICK_SIMPLE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RIGHT_CLICK, World.PROP_HAND_LEFT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, Item.PROP_RATE, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z));
        public static final IAspectProperties PROPERTIES_CLICK_NORATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RIGHT_CLICK, World.PROP_HAND_LEFT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z));
        public static final IAspectProperties PROPERTIES_CLICK = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RIGHT_CLICK, World.PROP_HAND_LEFT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, Item.PROP_CHECK_STACKSIZE, Item.PROP_CHECK_DAMAGE, Item.PROP_CHECK_NBT, Item.PROP_RATE, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, (Object[])new IAspectPropertyTypeInstance[]{World.PROP_OFFSET_Z}));
        public static final IAspectProperties PROPERTIES_CLICKLIST;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Void> PROP_CLICK_EMPTY;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Item.ItemInformation>, Item.ItemTarget> PROP_ITEMTARGET_CLICK;

        static {
            PROPERTIES_CLICK_EMPTY.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_SIMPLE.setValue(Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_NORATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK_NORATE.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NORATE.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NORATE.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_NORATE.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(World.PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK.setValue(Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK.setValue(Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
            PROPERTIES_CLICK.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICKLIST = PROPERTIES_CLICK.clone();
            PROPERTIES_CLICKLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICKLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROP_CLICK_EMPTY = input -> {
                if (((Boolean)input.getRight()).booleanValue()) {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    EnumHand hand = ((ValueTypeBoolean.ValueBoolean)properties.getValue(World.PROP_HAND_LEFT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                    boolean rightClick = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_RIGHT_CLICK)).getRawValue();
                    boolean continuousClick = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CONTINUOUS_CLICK)).getRawValue();
                    boolean sneak = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_SNEAK)).getRawValue();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(World.PROPERTY_ENTITYINDEX)).getRawValue();
                    double offsetX = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_X)).getRawValue();
                    double offsetY = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Y)).getRawValue();
                    double offsetZ = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Z)).getRawValue();
                    int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                    PartStatePlayerSimulator partState = (PartStatePlayerSimulator)PartHelpers.getPart((PartPos)center).getState();
                    ItemHandlerPlayerWrapper itemHandler = new ItemHandlerPlayerWrapper(partState.getPlayer(), (WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), offsetX, offsetY, offsetZ, target.getSide(), hand, rightClick, sneak, continuousClick, entityIndex, (ISlotlessItemHandler)((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY)).getChannel(channel));
                    itemHandler.insertItem(0, ItemStack.field_190927_a, false);
                }
                return null;
            };
            PROP_ITEMTARGET_CLICK = input -> {
                PartTarget partTarget = (PartTarget)input.getLeft();
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int amount = ((Item.ItemInformation)input.getRight()).getAmount();
                int transferHash = ((Item.ItemInformation)input.getRight()).getTransferHash();
                ItemStackPredicate itemStackMatcher = ((Item.ItemInformation)input.getRight()).getItemStackPredicate();
                EnumHand hand = ((ValueTypeBoolean.ValueBoolean)((IAspectProperties)input.getMiddle()).getValue(World.PROP_HAND_LEFT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                boolean rightClick = ((ValueTypeBoolean.ValueBoolean)((IAspectProperties)input.getMiddle()).getValue(PROP_RIGHT_CLICK)).getRawValue();
                boolean continuousClick = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CONTINUOUS_CLICK)).getRawValue();
                boolean sneak = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_SNEAK)).getRawValue();
                int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(World.PROPERTY_ENTITYINDEX)).getRawValue();
                double offsetX = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_X)).getRawValue();
                double offsetY = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Y)).getRawValue();
                double offsetZ = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Z)).getRawValue();
                int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                PartPos center = partTarget.getCenter();
                PartPos target = partTarget.getTarget();
                INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                PartStatePlayerSimulator partState = (PartStatePlayerSimulator)PartHelpers.getPart((PartPos)center).getState();
                ItemHandlerPlayerWrapper itemHandler = new ItemHandlerPlayerWrapper(partState.getPlayer(), (WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), offsetX, offsetY, offsetZ, target.getSide(), hand, rightClick, sneak, continuousClick, entityIndex, (ISlotlessItemHandler)((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY)).getChannel(channel));
                return new Item.ItemTarget(network, itemHandler, null, null, target.hashCode(), 0, amount, itemStackMatcher, transferHash, partTarget, properties);
            };
        }
    }

    public static final class World {
        public static final AspectBuilder<ValueObjectTypeBlock.ValueBlock, ValueObjectTypeBlock, Triple<PartTarget, IAspectProperties, ValueObjectTypeBlock.ValueBlock>> BUILDER_BLOCK_BASE = AspectWriteBuilders.getValue((AspectBuilder)AspectBuilder.forWriteType((IValueType)ValueTypes.OBJECT_BLOCK)).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeBlock.ValueBlock, ValueObjectTypeBlock, Triple<PartTarget, IAspectProperties, IBlockState>> BUILDER_BLOCK = BUILDER_BLOCK_BASE.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_BLOCK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").withProperties(PROPERTIES_CHANNEL);
        public static final Predicate<ValueTypeDouble.ValueDouble> VALIDATOR_DOUBLE_ANGLE = input -> input.getRawValue() >= -180.0 && input.getRawValue() <= 180.0;
        public static final Predicate<ValueTypeDouble.ValueDouble> VALIDATOR_DOUBLE_OFFSET = input -> input.getRawValue() >= 0.0 && input.getRawValue() <= 1.0;
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_BLOCK_UPDATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.blockupdate.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_HAND_LEFT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.lefthand.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_SILK_TOUCH = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.silktouch.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_IGNORE_REPLACABLE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.ignorereplacable.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_BREAK_ON_NO_DROPS = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.breaknodrops.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_IGNORE_PICK_UP_DELAY = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.ignorepickupdelay.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_DISPENSE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.dispense.name");
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_OFFSET_X = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.offsetx.name", VALIDATOR_DOUBLE_OFFSET);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_OFFSET_Y = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.offsety.name", VALIDATOR_DOUBLE_OFFSET);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_OFFSET_Z = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.offsetz.name", VALIDATOR_DOUBLE_OFFSET);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_LIFESPAN = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.boolean.world.lifespan.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_DELAY_BEFORE_PICKUP = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.boolean.world.delaybeforepickup.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_VELOCITY = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.velocity.name", input -> input.getRawValue() >= 0.0 && input.getRawValue() <= 25.0);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_YAW = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.yaw.name", VALIDATOR_DOUBLE_ANGLE);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_PITCH = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.pitch.name", VALIDATOR_DOUBLE_ANGLE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_ENTITYINDEX = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.entityindex.name");

        public static final class Block {
            public static final IAspectProperties PROPERTIES_ITEM_PLACE_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLOCK_UPDATE, PROP_HAND_LEFT, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_ITEM_PLACE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_HAND_LEFT, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UP_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLOCK_UPDATE, PROP_HAND_LEFT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS));
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UP = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_HAND_LEFT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS));
            public static final IAspectProperties PROPERTIES_BLOCK_PLACE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLOCK_UPDATE, PROP_HAND_LEFT, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_BLOCK_PICK_UP = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLOCK_UPDATE, PROP_HAND_LEFT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS));
            public static final IAspectProperties PROPERTIES_ITEM_PLACELIST;
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UPLIST;
            public static final IAspectProperties PROPERTIES_BLOCK_PLACELIST;
            public static final IAspectProperties PROPERTIES_BLOCK_PICK_UPLIST;
            public static final IAspectValuePropagator<Item.ItemTarget, Void> PROP_ITEMBLOCK_EXPORT;
            public static final IAspectValuePropagator<Item.ItemTarget, Void> PROP_ITEMBLOCK_IMPORT;

            static {
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE.setValue(PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_HAND_LEFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACELIST = PROPERTIES_ITEM_PLACE.clone();
                PROPERTIES_ITEM_PICK_UPLIST = PROPERTIES_ITEM_PICK_UP.clone();
                PROPERTIES_BLOCK_PLACELIST = PROPERTIES_BLOCK_PLACE.clone();
                PROPERTIES_BLOCK_PICK_UPLIST = PROPERTIES_BLOCK_PICK_UP.clone();
                PROPERTIES_ITEM_PLACELIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PLACELIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UPLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PICK_UPLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PLACELIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_BLOCK_PLACELIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UPLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_BLOCK_PICK_UPLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROP_ITEMBLOCK_EXPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    IItemNetwork itemNetwork = input.getItemNetwork();
                    if (target.getPos().isLoaded() && itemNetwork != null) {
                        EnumHand hand = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_HAND_LEFT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                        boolean blockUpdate = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BLOCK_UPDATE)).getRawValue();
                        boolean ignoreReplacable = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_IGNORE_REPLACABLE)).getRawValue();
                        TunnelItemHelpers.placeItems(input.getConnectionHash(), input.getItemChannel(), input.getInventoryStateNetwork(), input.getItemChannel(), target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), input.getItemStackMatcher(), hand, blockUpdate, ignoreReplacable);
                    }
                    return null;
                };
                PROP_ITEMBLOCK_IMPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    IItemNetwork itemNetwork = input.getItemNetwork();
                    if (target.getPos().isLoaded() && itemNetwork != null) {
                        EnumHand hand = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_HAND_LEFT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                        boolean blockUpdate = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BLOCK_UPDATE)).getRawValue();
                        boolean ignoreReplacable = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_IGNORE_REPLACABLE)).getRawValue();
                        int fortune = 0;
                        boolean silkTouch = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_SILK_TOUCH)).getRawValue();
                        boolean breakOnNoDrops = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BREAK_ON_NO_DROPS)).getRawValue();
                        TunnelItemHelpers.pickUpItems(input.getConnectionHash(), target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), input.getItemChannel(), input.getInventoryStateNetwork(), input.getItemChannel(), input.getItemStackMatcher(), hand, blockUpdate, ignoreReplacable, fortune, silkTouch, breakOnNoDrops);
                    }
                    return null;
                };
            }
        }

        public static final class Fluid {
            public static final IAspectProperties PROPERTIES_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_FLUID_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_FLUIDLIST_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLACKLIST, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_FLUID = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT));
            public static final IAspectProperties PROPERTIES_FLUIDLIST = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLACKLIST, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT));
            public static final IAspectProperties PROPERTIES_RATE = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATE.clone();
            public static final IAspectProperties PROPERTIES_RATECHECKS = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATECHECKS.clone();
            public static final IAspectProperties PROPERTIES_RATECHECKSLIST = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATECHECKSLIST.clone();
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Fluid.FluidTarget> PROP_BOOLEAN_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, Fluid.FluidTarget> PROP_FLUIDSTACK_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Fluid.FluidTarget> PROP_FLUIDSTACKLIST_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Fluid.FluidTarget> PROP_FLUIDSTACKPREDICATE_FLUIDTARGET;
            public static final IAspectValuePropagator<Fluid.FluidTarget, Void> PROP_FLUIDSTACK_EXPORT;
            public static final IAspectValuePropagator<Fluid.FluidTarget, Void> PROP_FLUIDSTACK_IMPORT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Pair<Predicate<FluidStack>, Integer>>, Fluid.FluidTarget> PROP_ENTITY_FLUIDTARGET;

            static {
                PROPERTIES_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUID_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUID_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUID_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUID_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUID.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUID.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUIDLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUIDLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_RATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATE.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKS.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKSLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKSLIST.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROP_BOOLEAN_FLUIDTARGET = input -> Fluid.FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), 1000, (Boolean)input.getRight() != false ? TunnelFluidHelpers.MATCH_ALL : TunnelFluidHelpers.MATCH_NONE);
                PROP_FLUIDSTACK_FLUIDTARGET = input -> {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT)).getRawValue();
                    return Fluid.FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), 1000, TunnelFluidHelpers.matchFluidStack((FluidStack)input.getRight(), false, checkNbt));
                };
                PROP_FLUIDSTACKLIST_FLUIDTARGET = input -> {
                    ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                    if (list.getRawValue().getValueType() != ValueTypes.OBJECT_FLUIDSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_FLUIDSTACK, list.getRawValue().getValueType()}).localize());
                    }
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT)).getRawValue();
                    boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                    Predicate<FluidStack> fluidStackPredicate = TunnelFluidHelpers.matchFluidStacks((IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>)list.getRawValue(), false, checkNbt);
                    if (blacklist) {
                        fluidStackPredicate = fluidStackPredicate.negate();
                    }
                    return Fluid.FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), 1000, fluidStackPredicate);
                };
                PROP_FLUIDSTACKPREDICATE_FLUIDTARGET = input -> {
                    IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                    if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_FLUIDSTACK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                        return Fluid.FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), 1000, TunnelFluidHelpers.matchPredicate((PartTarget)input.getLeft(), predicate));
                    }
                    String current = ValueTypeOperator.getSignature((IOperator)predicate);
                    String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_FLUIDSTACK}, (IValueType)ValueTypes.BOOLEAN);
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
                };
                PROP_FLUIDSTACK_EXPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    IFluidHandler fluidChannel = (IFluidHandler)input.getFluidNetwork().getChannel(((ValueTypeInteger.ValueInteger)input.getProperties().getValue(PROP_CHANNEL)).getRawValue());
                    DimPos pos = target.getPos();
                    if (pos.isLoaded() && input.getFluidNetwork() != null) {
                        TunnelFluidHelpers.placeFluids(fluidChannel, pos.getWorld(), pos.getBlockPos(), input.getFluidStackMatcher(), ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BLOCK_UPDATE)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_IGNORE_REPLACABLE)).getRawValue());
                    }
                    return null;
                };
                PROP_FLUIDSTACK_IMPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    IFluidHandler fluidChannel = (IFluidHandler)input.getFluidNetwork().getChannel(((ValueTypeInteger.ValueInteger)input.getProperties().getValue(PROP_CHANNEL)).getRawValue());
                    DimPos pos = target.getPos();
                    if (pos.isLoaded() && input.getFluidNetwork() != null) {
                        TunnelFluidHelpers.pickUpFluids(target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), fluidChannel, input.getFluidStackMatcher());
                    }
                    return null;
                };
                PROP_ENTITY_FLUIDTARGET = input -> {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = (Integer)((Pair)input.getRight()).getRight();
                    Predicate fluidStackPredicate = (Predicate)((Pair)input.getRight()).getLeft();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(PROPERTY_ENTITYINDEX)).getRawValue();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                    IFluidHandler fluidHandler = null;
                    Entity entity = (Entity)Iterables.get((Iterable)target.getPos().getWorld().func_72872_a(Entity.class, new AxisAlignedBB(target.getPos().getBlockPos())), (int)entityIndex, null);
                    if (entity != null && entity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.getSide())) {
                        fluidHandler = (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.getSide());
                    }
                    return new Fluid.FluidTarget(partTarget, (IFluidNetwork)network.getCapability(Capabilities.NETWORK_FLUID), fluidHandler, amount, fluidStackPredicate, properties);
                };
            }
        }

        public static final class Item {
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NORATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, PROP_IGNORE_PICK_UP_DELAY));
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_DISPENSE, PROP_OFFSET_X, PROP_OFFSET_Y, PROP_OFFSET_Z, PROP_LIFESPAN, PROP_DELAY_BEFORE_PICKUP, PROP_VELOCITY, PROP_YAW, PROP_PITCH));
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NORATE;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NOCHECKS;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UPLIST;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACELIST;
            public static final IAspectProperties PROPERTIES_RATESLOT;
            public static final IAspectProperties PROPERTIES_SLOT;
            public static final IAspectProperties PROPERTIES_RATESLOTCHECKS;
            public static final IAspectProperties PROPERTIES_RATESLOTCHECKSLIST;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Item.ItemTarget> PROP_BOOLEAN_ITEMTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Item.ItemInformation>, Item.ItemTarget> PROP_ENTITYITEM_ITEMTARGET_IMPORT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Item.ItemInformation>, Item.ItemTarget> PROP_ENTITYITEM_ITEMTARGET_EXPORT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Item.ItemInformation>, Item.ItemTarget> PROP_ENTITY_ITEMTARGET;

            public static <T> IAspectValuePropagator<Triple<PartTarget, IAspectProperties, T>, Triple<PartTarget, IAspectProperties, T>> ignoreStackSize() {
                return input -> {
                    IAspectProperties aspectProperties = ((IAspectProperties)input.getMiddle()).clone();
                    aspectProperties.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                    aspectProperties.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
                    return Triple.of((Object)input.getLeft(), (Object)aspectProperties, (Object)input.getRight());
                };
            }

            public static IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Item.ItemInformation>, Item.ItemTarget> newPropEntityItemItemTarget(boolean doImport) {
                return input -> {
                    Object itemHandler;
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = ((Item.ItemInformation)input.getRight()).getAmount();
                    int transferHash = ((Item.ItemInformation)input.getRight()).getTransferHash();
                    ItemStackPredicate itemStackMatcher = ((Item.ItemInformation)input.getRight()).getItemStackPredicate();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                    if (doImport) {
                        boolean ignorePickupDelay = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_IGNORE_PICK_UP_DELAY)).getRawValue();
                        itemHandler = new ItemHandlerWorldEntityImportWrapper((WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), ignorePickupDelay);
                    } else {
                        double offsetX = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_OFFSET_X)).getRawValue();
                        double offsetY = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_OFFSET_Y)).getRawValue();
                        double offsetZ = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_OFFSET_Z)).getRawValue();
                        int lifespan = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_LIFESPAN)).getRawValue();
                        int delayBeforePickup = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_DELAY_BEFORE_PICKUP)).getRawValue();
                        EnumFacing facing = center.getSide();
                        double velocity = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_VELOCITY)).getRawValue();
                        double yaw = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_YAW)).getRawValue();
                        double pitch = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_PITCH)).getRawValue();
                        boolean dispense = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_DISPENSE)).getRawValue();
                        int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                        itemHandler = new ItemHandlerWorldEntityExportWrapper((WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), offsetX, offsetY, offsetZ, lifespan, delayBeforePickup, facing, velocity, yaw, pitch, dispense, (ISlotlessItemHandler)((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY)).getChannel(channel));
                    }
                    int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_SLOT)).getRawValue();
                    return new Item.ItemTarget(network, (IItemHandler)itemHandler, null, null, target.hashCode(), slot, amount, itemStackMatcher, transferHash, partTarget, properties);
                };
            }

            static {
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_DISPENSE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_LIFESPAN, (IValue)ValueTypeInteger.ValueInteger.of((int)6000));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_DELAY_BEFORE_PICKUP, (IValue)ValueTypeInteger.ValueInteger.of((int)10));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_VELOCITY, (IValue)ValueTypeDouble.ValueDouble.of((double)0.1));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_YAW, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_PITCH, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
                PROPERTIES_ENTITYITEM_PICK_UP = PROPERTIES_ENTITYITEM_PICK_UP_NORATE.clone();
                PROPERTIES_ENTITYITEM_PLACE_NORATE = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEM_PLACE_NOCHECKS = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEM_PLACE = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_IGNORE_PICK_UP_DELAY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_IGNORE_PICK_UP_DELAY));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PLACE_NOCHECKS.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PICK_UPLIST = PROPERTIES_ENTITYITEM_PICK_UP.clone();
                PROPERTIES_ENTITYITEM_PLACELIST = PROPERTIES_ENTITYITEM_PLACE.clone();
                PROPERTIES_ENTITYITEM_PICK_UPLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UPLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACELIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PLACELIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_RATESLOT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_RATESLOT.clone();
                PROPERTIES_SLOT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_SLOT.clone();
                PROPERTIES_RATESLOTCHECKS = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_RATESLOTCHECKS.clone();
                PROPERTIES_RATESLOT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_SLOT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_SLOT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKS.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKSLIST = PROPERTIES_RATESLOTCHECKS.clone();
                PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROP_BOOLEAN_ITEMTARGET = input -> Item.ItemTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), 1, (Boolean)input.getRight() != false ? TunnelItemHelpers.MATCH_BLOCK : TunnelItemHelpers.MATCH_NONE, (Boolean)input.getRight() != false ? 1 : 0, ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_SLOT)).getRawValue());
                PROP_ENTITYITEM_ITEMTARGET_IMPORT = Item.newPropEntityItemItemTarget(true);
                PROP_ENTITYITEM_ITEMTARGET_EXPORT = Item.newPropEntityItemItemTarget(false);
                PROP_ENTITY_ITEMTARGET = input -> {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = ((Item.ItemInformation)input.getRight()).getAmount();
                    int transferHash = ((Item.ItemInformation)input.getRight()).getTransferHash();
                    ItemStackPredicate itemStackMatcher = ((Item.ItemInformation)input.getRight()).getItemStackPredicate();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(PROPERTY_ENTITYINDEX)).getRawValue();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                    IItemHandler itemHandler = null;
                    Entity entity = (Entity)Iterables.get((Iterable)target.getPos().getWorld().func_72872_a(Entity.class, new AxisAlignedBB(target.getPos().getBlockPos())), (int)entityIndex, null);
                    if (entity != null && entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.getSide())) {
                        itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.getSide());
                    }
                    int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_SLOT)).getRawValue();
                    return new Item.ItemTarget(network, itemHandler, null, null, target.hashCode(), slot, amount, itemStackMatcher, transferHash, partTarget, properties);
                };
            }
        }

        public static final class Energy {
            public static final IAspectProperties PROPERTIES = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Energy.PROPERTIES.clone();
            public static final IAspectProperties PROPERTIES_ENTITY;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Energy.EnergyTarget> PROP_ENTITY_ENERGYTARGET;

            static {
                PROPERTIES.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITY = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROPERTY_ENTITYINDEX));
                PROPERTIES_ENTITY.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITY.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROP_ENTITY_ENERGYTARGET = input -> {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = (Integer)input.getRight();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(PROPERTY_ENTITYINDEX)).getRawValue();
                    int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                    IEnergyStorage energyStorage = null;
                    Entity entity = (Entity)Iterables.get((Iterable)target.getPos().getWorld().func_72872_a(Entity.class, new AxisAlignedBB(target.getPos().getBlockPos())), (int)entityIndex, null);
                    if (entity != null && entity.hasCapability(CapabilityEnergy.ENERGY, target.getSide())) {
                        energyStorage = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, target.getSide());
                    }
                    return new Energy.EnergyTarget((IEnergyStorage)((IEnergyNetwork)network.getCapability(Capabilities.NETWORK_ENERGY)).getChannel(channel), energyStorage, amount);
                };
            }
        }
    }

    public static final class Fluid {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(() -> FluidNetworkConfig.CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(() -> FluidNetworkConfig.CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").withProperties(PROPERTIES_CHANNEL);
        public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_MAXRATE = input -> input.getRawValue() <= GeneralConfig.fluidRateLimit;
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.fluid.rate.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE.and(VALIDATOR_INTEGER_MAXRATE));
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_AMOUNT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.checkamount.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_NBT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.checknbt.name");
        public static final IAspectProperties PROPERTIES_RATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE));
        public static final IAspectProperties PROPERTIES_RATECHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE, PROP_CHECK_AMOUNT, PROP_CHECK_NBT));
        public static final IAspectProperties PROPERTIES_RATECHECKSLIST = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLACKLIST, PROP_RATE, PROP_CHECK_AMOUNT, PROP_CHECK_NBT));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_BOOLEAN_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Triple<PartTarget, IAspectProperties, Pair<Predicate<FluidStack>, Integer>>> PROP_INTEGER_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, Triple<PartTarget, IAspectProperties, Pair<Predicate<FluidStack>, Integer>>> PROP_FLUIDSTACK_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Triple<PartTarget, IAspectProperties, Pair<Predicate<FluidStack>, Integer>>> PROP_FLUIDSTACKLIST_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Triple<PartTarget, IAspectProperties, Pair<Predicate<FluidStack>, Integer>>> PROP_FLUIDSTACKPREDICATE_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Pair<Predicate<FluidStack>, Integer>>, FluidTarget> PROP_FLUIDTARGET;
        public static final IAspectValuePropagator<FluidTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<FluidTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES_RATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATE.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATECHECKS.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKS.setValue(PROP_CHECK_AMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_CHECK_AMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROP_BOOLEAN_GETRATE = input -> Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
            PROP_INTEGER_FLUIDPREDICATE = input -> Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)Pair.of(TunnelFluidHelpers.MATCH_ALL, (Object)input.getRight()));
            PROP_FLUIDSTACK_FLUIDPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                boolean checkAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_AMOUNT)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)Pair.of(TunnelFluidHelpers.matchFluidStack((FluidStack)input.getRight(), checkAmount, checkNbt), (Object)rate));
            };
            PROP_FLUIDSTACKLIST_FLUIDPREDICATE = input -> {
                ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                if (list.getRawValue().getValueType() != ValueTypes.OBJECT_FLUIDSTACK) {
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_FLUIDSTACK, list.getRawValue().getValueType()}).localize());
                }
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                boolean checkAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_AMOUNT)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                Predicate<FluidStack> fluidStackPredicate = TunnelFluidHelpers.matchFluidStacks((IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>)list.getRawValue(), checkAmount, checkNbt);
                if (blacklist) {
                    fluidStackPredicate = fluidStackPredicate.negate();
                }
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)Pair.of(fluidStackPredicate, (Object)rate));
            };
            PROP_FLUIDSTACKPREDICATE_FLUIDPREDICATE = input -> {
                IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_FLUIDSTACK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)Pair.of(TunnelFluidHelpers.matchPredicate((PartTarget)input.getLeft(), predicate), (Object)rate));
                }
                String current = ValueTypeOperator.getSignature((IOperator)predicate);
                String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_FLUIDSTACK}, (IValueType)ValueTypes.BOOLEAN);
                throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
            };
            PROP_FLUIDTARGET = input -> FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), (Integer)((Pair)input.getRight()).getRight(), (Predicate)((Pair)input.getRight()).getLeft());
            PROP_EXPORT = input -> {
                if (input.getFluidNetwork() != null && input.getFluidHandler() != null && input.getAmount() != 0) {
                    TunnelFluidHelpers.moveFluids(input.getFluidChannel(), input.getFluidHandler(), input.getAmount(), true, input.getFluidStackMatcher());
                }
                return null;
            };
            PROP_IMPORT = input -> {
                if (input.getFluidNetwork() != null && input.getFluidHandler() != null && input.getAmount() != 0) {
                    TunnelFluidHelpers.moveFluids(input.getFluidHandler(), input.getFluidChannel(), input.getAmount(), true, input.getFluidStackMatcher());
                }
                return null;
            };
        }

        public static class FluidTarget {
            private final PartTarget partTarget;
            private final IFluidNetwork fluidNetwork;
            private final IFluidHandler fluidChannel;
            private final IFluidHandler fluidHandler;
            private final int amount;
            private final Predicate<FluidStack> fluidStackMatcher;
            private final IAspectProperties properties;

            public static FluidTarget of(PartTarget partTarget, IAspectProperties properties, int amount, Predicate<FluidStack> fluidStackMatcher) {
                PartPos center = partTarget.getCenter();
                PartPos target = partTarget.getTarget();
                INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                IFluidHandler fluidHandler = FluidUtil.getFluidHandler((net.minecraft.world.World)target.getPos().getWorld(), (BlockPos)target.getPos().getBlockPos(), (EnumFacing)target.getSide());
                return new FluidTarget(partTarget, (IFluidNetwork)network.getCapability(FluidNetworkConfig.CAPABILITY), fluidHandler, amount, fluidStackMatcher, properties);
            }

            public FluidTarget(PartTarget partTarget, IFluidNetwork fluidNetwork, IFluidHandler fluidHandler, int amount, Predicate<FluidStack> fluidStackMatcher, IAspectProperties properties) {
                this.partTarget = partTarget;
                this.fluidNetwork = fluidNetwork;
                this.fluidChannel = (IFluidHandler)this.fluidNetwork.getChannel(((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue());
                this.fluidHandler = fluidHandler;
                this.amount = amount;
                this.fluidStackMatcher = fluidStackMatcher;
                this.properties = properties;
            }

            public PartTarget getPartTarget() {
                return this.partTarget;
            }

            public IFluidNetwork getFluidNetwork() {
                return this.fluidNetwork;
            }

            public IFluidHandler getFluidChannel() {
                return this.fluidChannel;
            }

            public IFluidHandler getFluidHandler() {
                return this.fluidHandler;
            }

            public int getAmount() {
                return this.amount;
            }

            public Predicate<FluidStack> getFluidStackMatcher() {
                return this.fluidStackMatcher;
            }

            public IAspectProperties getProperties() {
                return this.properties;
            }
        }
    }

    public static final class Item {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(() -> ItemNetworkConfig.CAPABILITY, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(() -> ItemNetworkConfig.CAPABILITY, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").withProperties(PROPERTIES_CHANNEL);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.item.rate.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_SLOT = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.item.slot.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_STACKSIZE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checkstacksize.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_DAMAGE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checkdamage.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_NBT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checknbt.name");
        public static final IAspectProperties PROPERTIES_RATESLOT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE, PROP_SLOT));
        public static final IAspectProperties PROPERTIES_SLOT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_SLOT));
        public static final IAspectProperties PROPERTIES_RATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE));
        public static final IAspectProperties PROPERTIES_RATESLOTCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE, PROP_SLOT, PROP_CHECK_STACKSIZE, PROP_CHECK_DAMAGE, PROP_CHECK_NBT));
        public static final IAspectProperties PROPERTIES_RATESLOTCHECKSLIST = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLACKLIST, PROP_RATE, PROP_SLOT, PROP_CHECK_STACKSIZE, PROP_CHECK_DAMAGE, PROP_CHECK_NBT));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_BOOLEAN_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_INTEGER_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_INTEGER_SLOT_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ItemStack>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_ITEMSTACK_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_ITEMSTACKLIST_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_ITEMSTACKPREDICATE_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, IBlockState>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_BLOCK_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_BLOCKLIST_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Triple<PartTarget, IAspectProperties, ItemInformation>> PROP_BLOCKPREDICATE_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ItemInformation>, ItemTarget> PROP_ITEMTARGET;
        public static final IAspectValuePropagator<ItemTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<ItemTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES_RATESLOT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_SLOT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_SLOT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATE.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROP_BOOLEAN_ITEMPREDICATE = input -> {
                ItemStackPredicate itemStackMatcher = (Boolean)input.getRight() != false ? TunnelItemHelpers.MATCH_BLOCK : TunnelItemHelpers.MATCH_NONE;
                int amount = (Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0;
                int transferHash = (Boolean)input.getRight() != false ? 1 : 0;
                int slot = ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_INTEGER_ITEMPREDICATE = input -> {
                ItemStackPredicate itemStackMatcher = TunnelItemHelpers.MATCH_ALL;
                int amount = (Integer)input.getRight();
                int transferHash = (Integer)input.getRight();
                int slot = ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_INTEGER_SLOT_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                ItemStackPredicate itemStackMatcher = TunnelItemHelpers.MATCH_ALL;
                int amount = (Integer)input.getRight() >= -1 ? ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue() : 0;
                int transferHash = (Integer)input.getRight() > 0 ? 1 : 0;
                int slot = (Integer)input.getRight();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_ITEMSTACK_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean checkStackSize = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_STACKSIZE)).getRawValue();
                boolean checkDamage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_DAMAGE)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                ItemStackPredicate itemStackMatcher = TunnelItemHelpers.matchItemStack((ItemStack)input.getRight(), checkStackSize, checkDamage, checkNbt);
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                int transferHash = ItemStackHelpers.getItemStackHashCode((ItemStack)((ItemStack)input.getRight()));
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_ITEMSTACKLIST_ITEMPREDICATE = input -> {
                ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                if (list.getRawValue().getValueType() != ValueTypes.OBJECT_ITEMSTACK) {
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_ITEMSTACK, list.getRawValue().getValueType()}).localize());
                }
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean checkStackSize = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_STACKSIZE)).getRawValue();
                boolean checkDamage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_DAMAGE)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                ItemStackPredicate itemStackMatcher = TunnelItemHelpers.matchItemStacks((IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>)list.getRawValue(), checkStackSize, checkDamage, checkNbt, blacklist);
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                int transferHash = list.getRawValue().hashCode();
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_ITEMSTACKPREDICATE_ITEMPREDICATE = input -> {
                IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_ITEMSTACK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    ItemStackPredicate itemStackMatcher = TunnelItemHelpers.matchPredicateItem((PartTarget)input.getLeft(), predicate);
                    int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    int transferHash = predicate.hashCode();
                    int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
                }
                String current = ValueTypeOperator.getSignature((IOperator)predicate);
                String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_ITEMSTACK}, (IValueType)ValueTypes.BOOLEAN);
                throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
            };
            PROP_BLOCK_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((IBlockState)((IBlockState)input.getRight()));
                ItemStackPredicate itemStackMatcher = TunnelItemHelpers.matchItemStack(itemStack, false, true, false);
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                int transferHash = ItemStackHelpers.getItemStackHashCode((ItemStack)itemStack);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_BLOCKLIST_ITEMPREDICATE = input -> {
                ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                if (list.getRawValue().getValueType() != ValueTypes.OBJECT_BLOCK) {
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_BLOCK, list.getRawValue().getValueType()}).localize());
                }
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                ItemStackPredicate itemStackMatcher = TunnelItemHelpers.matchBlocks((IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock>)list.getRawValue(), false, true, false, blacklist);
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                int transferHash = list.getRawValue().hashCode();
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
            };
            PROP_BLOCKPREDICATE_ITEMPREDICATE = input -> {
                IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_BLOCK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    ItemStackPredicate itemStackMatcher = TunnelItemHelpers.matchPredicateBlock((PartTarget)input.getLeft(), predicate);
                    int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    int transferHash = predicate.hashCode();
                    int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)ItemInformation.of(itemStackMatcher, amount, transferHash, slot));
                }
                String current = ValueTypeOperator.getSignature((IOperator)predicate);
                String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_BLOCK}, (IValueType)ValueTypes.BOOLEAN);
                throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
            };
            PROP_ITEMTARGET = input -> ItemTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), ((ItemInformation)input.getRight()).getAmount(), ((ItemInformation)input.getRight()).getItemStackPredicate(), ((ItemInformation)input.getRight()).getTransferHash(), ((ItemInformation)input.getRight()).getSlot());
            PROP_EXPORT = input -> {
                if (input.getItemNetwork() != null && input.getItemStorage() != null && input.getAmount() != 0) {
                    int channel = ((ValueTypeInteger.ValueInteger)input.getProperties().getValue(PROP_CHANNEL)).getRawValue();
                    TunnelItemHelpers.moveItemsStateOptimized(input.getConnectionHash(), input.getItemChannel(), input.getInventoryStateNetwork(), -1, input.getItemChannel(), input.getItemStorage(), input.getInventoryStateStorage(), input.getSlot(), input.getItemStorageSlotless(), input.getAmount(), input.getItemStackMatcher());
                }
                return null;
            };
            PROP_IMPORT = input -> {
                if (input.getItemNetwork() != null && input.getItemStorage() != null && input.getAmount() != 0) {
                    TunnelItemHelpers.moveItemsStateOptimized(input.getConnectionHash(), input.getItemStorage(), input.getInventoryStateStorage(), input.getSlot(), input.getItemStorageSlotless(), input.getItemChannel(), input.getInventoryStateNetwork(), -1, input.getItemChannel(), input.getAmount(), input.getItemStackMatcher());
                }
                return null;
            };
        }

        public static class ItemTarget {
            private final IItemNetwork itemNetwork;
            private final IItemNetwork.IItemChannel itemChannel;
            private final IItemHandler itemStorage;
            private final IInventoryState inventoryStateNetwork;
            private final IInventoryState inventoryStateStorage;
            private final ISlotlessItemHandler itemStorageSlotless;
            private final int connectionHash;
            private final int slot;
            private final int amount;
            private final ItemStackPredicate itemStackMatcher;
            private final PartTarget partTarget;
            private final IAspectProperties properties;

            public static ItemTarget of(PartTarget partTarget, IAspectProperties properties, int amount, ItemStackPredicate itemStackMatcher, int transferHash, int slot) {
                PartPos center = partTarget.getCenter();
                PartPos target = partTarget.getTarget();
                INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                IItemHandler itemHandler = (IItemHandler)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                return new ItemTarget(network, itemHandler, (IInventoryState)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), Capabilities.INVENTORY_STATE), (ISlotlessItemHandler)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), Capabilities.SLOTLESS_ITEMHANDLER), target.hashCode(), slot, amount, itemStackMatcher, transferHash, partTarget, properties);
            }

            public ItemTarget(INetwork network, IItemHandler itemStorage, IInventoryState inventoryStateStorage, ISlotlessItemHandler itemStorageSlotless, int storagePosHash, int slot, int amount, ItemStackPredicate itemStackMatcher, int transferHash, PartTarget partTarget, IAspectProperties properties) {
                this.itemNetwork = (IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY);
                this.itemChannel = (IItemNetwork.IItemChannel)this.itemNetwork.getChannel(((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue());
                this.itemStorage = itemStorage;
                this.inventoryStateNetwork = network.hasCapability(Capabilities.INVENTORY_STATE) ? (IInventoryState)network.getCapability(Capabilities.INVENTORY_STATE) : null;
                this.inventoryStateStorage = inventoryStateStorage;
                this.itemStorageSlotless = itemStorageSlotless;
                this.connectionHash = transferHash << 4 + storagePosHash + this.itemNetwork.hashCode();
                this.slot = slot;
                this.amount = amount;
                this.itemStackMatcher = itemStackMatcher;
                this.partTarget = partTarget;
                this.properties = properties;
            }

            public IItemNetwork getItemNetwork() {
                return this.itemNetwork;
            }

            public IItemNetwork.IItemChannel getItemChannel() {
                return this.itemChannel;
            }

            public IItemHandler getItemStorage() {
                return this.itemStorage;
            }

            public IInventoryState getInventoryStateNetwork() {
                return this.inventoryStateNetwork;
            }

            public IInventoryState getInventoryStateStorage() {
                return this.inventoryStateStorage;
            }

            public ISlotlessItemHandler getItemStorageSlotless() {
                return this.itemStorageSlotless;
            }

            public int getConnectionHash() {
                return this.connectionHash;
            }

            public int getSlot() {
                return this.slot;
            }

            public int getAmount() {
                return this.amount;
            }

            public ItemStackPredicate getItemStackMatcher() {
                return this.itemStackMatcher;
            }

            public PartTarget getPartTarget() {
                return this.partTarget;
            }

            public IAspectProperties getProperties() {
                return this.properties;
            }
        }

        public static class ItemInformation {
            private final ItemStackPredicate itemStackPredicate;
            private final int amount;
            private final int transferHash;
            private final int slot;

            protected ItemInformation(ItemStackPredicate itemStackPredicate, int amount, int transferHash, int slot) {
                this.itemStackPredicate = itemStackPredicate;
                this.amount = amount;
                this.transferHash = transferHash;
                this.slot = slot;
            }

            public static ItemInformation of(ItemStackPredicate itemStackPredicate, int amount, int transferHash, int slot) {
                return new ItemInformation(itemStackPredicate, amount, transferHash, slot);
            }

            public ItemStackPredicate getItemStackPredicate() {
                return this.itemStackPredicate;
            }

            public int getAmount() {
                return this.amount;
            }

            public int getTransferHash() {
                return this.transferHash;
            }

            public int getSlot() {
                return this.slot;
            }
        }
    }

    public static final class Energy {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(() -> Capabilities.NETWORK_ENERGY, CapabilityEnergy.ENERGY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(() -> Capabilities.NETWORK_ENERGY, CapabilityEnergy.ENERGY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("energy").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("energy").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_MAXRATE = input -> input.getRawValue() <= org.cyclops.integrateddynamics.GeneralConfig.energyRateLimit;
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.energy.rate.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE.and(VALIDATOR_INTEGER_MAXRATE));
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, EnergyTarget> PROP_ENERGYTARGET;
        public static final IAspectValuePropagator<EnergyTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<EnergyTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROP_GETRATE = input -> Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
            PROP_ENERGYTARGET = input -> {
                PartPos center = ((PartTarget)input.getLeft()).getCenter();
                PartPos target = ((PartTarget)input.getLeft()).getTarget();
                INetwork network = TunnelAspectWriteBuilders.getNetworkChecked(center);
                IEnergyStorage energyStorage = EnergyHelpers.getEnergyStorage((PartPos)target);
                int channel = ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_CHANNEL)).getRawValue();
                return new EnergyTarget((IEnergyStorage)((IEnergyNetwork)network.getCapability(Capabilities.NETWORK_ENERGY)).getChannel(channel), energyStorage, (Integer)input.getRight());
            };
            PROP_EXPORT = input -> {
                if (input.getEnergyChannel() != null && input.getEnergyStorage() != null && input.getAmount() != 0) {
                    TunnelEnergyHelpers.moveEnergy(input.getEnergyChannel(), input.getEnergyStorage(), input.getAmount());
                }
                return null;
            };
            PROP_IMPORT = input -> {
                if (input.getEnergyChannel() != null && input.getEnergyStorage() != null && input.getAmount() != 0) {
                    TunnelEnergyHelpers.moveEnergy(input.getEnergyStorage(), input.getEnergyChannel(), input.getAmount());
                }
                return null;
            };
        }

        public static class EnergyTarget {
            private final IEnergyStorage energyChannel;
            private final IEnergyStorage energyStorage;
            private final int amount;

            public EnergyTarget(IEnergyStorage energyChannel, IEnergyStorage energyStorage, int amount) {
                this.energyChannel = energyChannel;
                this.energyStorage = energyStorage;
                this.amount = amount;
            }

            public IEnergyStorage getEnergyChannel() {
                return this.energyChannel;
            }

            public IEnergyStorage getEnergyStorage() {
                return this.energyStorage;
            }

            public int getAmount() {
                return this.amount;
            }
        }
    }
}

