/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;

public abstract class MappingCollector<T, V extends Comparable<V>, A extends IValueArithmetic<V>>
extends AbstractMappingCollector<T, V, A> {
    private static final boolean DEBUG_GRAPHMAPPER = false;
    protected final A arithmetic;
    protected final Map<T, Conversion> overwriteConversion = new HashMap<T, Conversion>();
    protected final Map<T, Set<Conversion>> conversionsFor = new HashMap<T, Set<Conversion>>();
    private final Map<T, Set<Conversion>> usedIn = new HashMap<T, Set<Conversion>>();
    protected final Map<T, V> fixValueBeforeInherit = new HashMap<T, V>();
    protected final Map<T, V> fixValueAfterInherit = new HashMap<T, V>();
    private final Map<T, Integer> noDependencyConversionCount = new HashMap<T, Integer>();

    protected MappingCollector(A arithmetic) {
        super(arithmetic);
        this.arithmetic = arithmetic;
    }

    protected static void debugFormat(String format, Object ... args) {
    }

    protected static void debugPrintln(String s) {
        MappingCollector.debugFormat(s, new Object[0]);
    }

    private Set<Conversion> getConversionsFor(T something) {
        return this.conversionsFor.computeIfAbsent(something, t -> new LinkedHashSet());
    }

    protected Set<Conversion> getUsesFor(T something) {
        return this.usedIn.computeIfAbsent(something, t -> new LinkedHashSet());
    }

    private int getNoDependencyConversionCountFor(T something) {
        Integer count = this.noDependencyConversionCount.get(something);
        if (count == null) {
            return 0;
        }
        return count;
    }

    private void increaseNoDependencyConversionCountFor(T something) {
        this.noDependencyConversionCount.put(something, this.getNoDependencyConversionCountFor(something) + 1);
    }

    private void addConversionToIngredientUsages(Conversion conversion) {
        for (Map.Entry ingredient : conversion.ingredientsWithAmount.entrySet()) {
            Set<Conversion> usesForIngredient = this.getUsesFor(ingredient.getKey());
            if (ingredient.getValue() == null) {
                throw new IllegalArgumentException("ingredient amount value has to be != null");
            }
            usesForIngredient.add(conversion);
        }
    }

    @Override
    public void addConversion(int outnumber, T output, Map<T, Integer> ingredientsWithAmount, A arithmeticForConversion) {
        ingredientsWithAmount = Maps.newHashMap(ingredientsWithAmount);
        if (output == null || ingredientsWithAmount.containsKey(null)) {
            PECore.LOGGER.warn("Ignoring Recipe because of invalid ingredient or output: {} -> {}x{}", (Object)ingredientsWithAmount, (Object)outnumber, output);
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(this, output, outnumber, (Map)ingredientsWithAmount, arithmeticForConversion, this.arithmetic.getZero());
        if (!this.getConversionsFor(output).add(conversion)) {
            return;
        }
        if (ingredientsWithAmount.isEmpty()) {
            this.increaseNoDependencyConversionCountFor(output);
        }
        this.addConversionToIngredientUsages(conversion);
    }

    @Override
    public void setValueBefore(T something, V value) {
        if (something == null) {
            return;
        }
        if (this.fixValueBeforeInherit.containsKey(something)) {
            PECore.LOGGER.warn("Overwriting fixValueBeforeInherit for {}:{} to {}", something, this.fixValueBeforeInherit.get(something), value);
        }
        this.fixValueBeforeInherit.put(something, value);
        this.fixValueAfterInherit.remove(something);
    }

    @Override
    public void setValueAfter(T something, V value) {
        if (something == null) {
            return;
        }
        if (this.fixValueAfterInherit.containsKey(something)) {
            PECore.LOGGER.warn("Overwriting fixValueAfterInherit for {}:{} to {}", something, this.fixValueAfterInherit.get(something), value);
        }
        this.fixValueAfterInherit.put(something, value);
    }

    @Override
    public void setValueFromConversion(int outnumber, T something, Map<T, Integer> ingredientsWithAmount) {
        if (something == null || ingredientsWithAmount.containsKey(null)) {
            PECore.LOGGER.warn("Ignoring setValueFromConversion because of invalid ingredient or output: {} -> {}x{}", ingredientsWithAmount, (Object)outnumber, something);
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(this, something, outnumber, ingredientsWithAmount, this.arithmetic);
        if (this.overwriteConversion.containsKey(something)) {
            Conversion oldConversion = this.overwriteConversion.get(something);
            PECore.LOGGER.warn("Overwriting setValueFromConversion {} with {}", (Object)this.overwriteConversion.get(something), (Object)conversion);
            for (T ingredient : ingredientsWithAmount.keySet()) {
                this.getUsesFor(ingredient).remove(oldConversion);
            }
        }
        this.addConversionToIngredientUsages(conversion);
        this.overwriteConversion.put(something, conversion);
    }

    public abstract Map<T, V> generateValues();

    protected static class Conversion {
        public final T output;
        public final int outnumber;
        public final V value;
        public final Map<T, Integer> ingredientsWithAmount;
        public final A arithmeticForConversion;
        final /* synthetic */ MappingCollector this$0;

        Conversion(T output, int outnumber, Map<T, Integer> ingredientsWithAmount, A arithmeticForConversion) {
            this(this$0, output, outnumber, ingredientsWithAmount, (IValueArithmetic)arithmeticForConversion, (Comparable)this$0.arithmetic.getZero());
        }

        Conversion(T output, int outnumber, Map<T, Integer> ingredientsWithAmount, A arithmeticForConversion, V value) {
            this.this$0 = this$0;
            this.output = output;
            this.outnumber = outnumber;
            this.ingredientsWithAmount = ingredientsWithAmount == null ? Collections.emptyMap() : ingredientsWithAmount;
            this.arithmeticForConversion = arithmeticForConversion;
            this.value = value;
        }

        public String toString() {
            return "" + this.value + " + " + this.ingredientsToString() + " => " + this.outnumber + "*" + this.output;
        }

        private String ingredientsToString() {
            if (this.ingredientsWithAmount == null || this.ingredientsWithAmount.size() == 0) {
                return "nothing";
            }
            return this.ingredientsWithAmount.entrySet().stream().map(e -> e.getValue() + "*" + e.getKey()).collect(Collectors.joining(" + "));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Conversion)) {
                return false;
            }
            Conversion other = (Conversion)o;
            return Objects.equals(this.output, other.output) && Objects.equals(this.value, other.value) && Objects.equals(this.ingredientsWithAmount, other.ingredientsWithAmount);
        }

        public int hashCode() {
            return Objects.hash(this.output, this.value, this.ingredientsWithAmount);
        }
    }
}

