/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.emc.collector.IExtendedMappingCollector;
import moze_intel.projecte.emc.collector.MappingCollector;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;

public class WildcardSetValueFixCollector<V extends Comparable<V>, A extends IValueArithmetic>
extends AbstractMappingCollector<NormalizedSimpleStack, V, A> {
    final IExtendedMappingCollector<NormalizedSimpleStack, V, A> inner;
    final Map<NSSItem, V> setValueBeforeMap = new HashMap<NSSItem, V>();
    final Map<NSSItem, V> setValueAfterMap = new HashMap<NSSItem, V>();
    final List<CustomConversion> setValueConversionList = new ArrayList<CustomConversion>();

    public WildcardSetValueFixCollector(IExtendedMappingCollector<NormalizedSimpleStack, V, A> inner) {
        super(inner.getArithmetic());
        this.inner = inner;
    }

    private boolean isWildCard(NormalizedSimpleStack nss) {
        return nss instanceof NSSItem && ((NSSItem)nss).damage == Short.MAX_VALUE;
    }

    @Override
    public void setValueBefore(NormalizedSimpleStack something, V value) {
        if (this.isWildCard(something)) {
            this.setValueBeforeMap.put((NSSItem)something, value);
        } else {
            this.inner.setValueBefore(something, value);
        }
    }

    @Override
    public void setValueAfter(NormalizedSimpleStack something, V value) {
        if (this.isWildCard(something)) {
            this.setValueAfterMap.put((NSSItem)something, value);
        } else {
            this.inner.setValueAfter(something, value);
        }
    }

    @Override
    public void setValueFromConversion(int outnumber, NormalizedSimpleStack something, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount) {
        if (this.isWildCard(something)) {
            this.setValueConversionList.add(CustomConversion.getFor(outnumber, something, ingredientsWithAmount));
        } else {
            this.inner.setValueFromConversion(outnumber, something, ingredientsWithAmount);
        }
    }

    @Override
    public void addConversion(int outnumber, NormalizedSimpleStack output, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount, A arithmeticForConversion) {
        this.inner.addConversion(outnumber, output, ingredientsWithAmount, arithmeticForConversion);
    }

    @Override
    public void finishCollection() {
        for (Map.Entry<NSSItem, V> entry : this.setValueBeforeMap.entrySet()) {
            for (Integer meta : NSSItem.getUsedMetadata(entry.getKey())) {
                if (meta == Short.MAX_VALUE) continue;
                MappingCollector.debugFormat("Inserting Wildcard SetValueBefore {}:{} to {}", entry.getKey().itemName, meta, entry.getValue());
                this.inner.setValueBefore(NSSItem.create(entry.getKey().itemName, (int)meta), (Comparable)entry.getValue());
            }
        }
        for (Map.Entry<NSSItem, V> entry : this.setValueAfterMap.entrySet()) {
            for (Integer meta : NSSItem.getUsedMetadata(entry.getKey())) {
                if (meta == Short.MAX_VALUE) continue;
                this.inner.setValueAfter(NSSItem.create(entry.getKey().itemName, (int)meta), (Comparable)entry.getValue());
                MappingCollector.debugFormat("Inserting Wildcard SetValueAfter: {}:{} to {}", entry.getKey().itemName, meta, entry.getValue());
            }
        }
        for (CustomConversion conversion : this.setValueConversionList) {
            for (Integer meta : NSSItem.getUsedMetadata(conversion.output)) {
                if (meta == Short.MAX_VALUE) continue;
                MappingCollector.debugFormat("Inserting Wildcard SetValueFromConversion {}:{} to {}", conversion.output, meta, conversion);
                this.inner.setValueFromConversion(conversion.count, NSSItem.create(((NSSItem)conversion.output).itemName, (int)meta), conversion.ingredients);
            }
        }
        this.inner.finishCollection();
    }
}

