/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.json;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NSSItem
implements NormalizedSimpleStack {
    static final Map<String, Set<Integer>> idWithUsedMetaData = new HashMap<String, Set<Integer>>();
    public final String itemName;
    public final int damage;

    NSSItem(String itemName, int damage) {
        this.itemName = itemName;
        this.damage = damage;
    }

    public static NormalizedSimpleStack create(Block block) {
        return NSSItem.create(block, 0);
    }

    public static NormalizedSimpleStack create(Block block, int meta) {
        return NSSItem.create(block.getRegistryName(), meta);
    }

    public static NormalizedSimpleStack create(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return NSSItem.create(stack.func_77973_b(), stack.func_77952_i());
    }

    public static NormalizedSimpleStack create(Item item) {
        return NSSItem.create(item, 0);
    }

    private static NormalizedSimpleStack create(Item item, int meta) {
        return NSSItem.create(item.getRegistryName(), meta);
    }

    private static NormalizedSimpleStack create(ResourceLocation uniqueIdentifier, int damage) {
        if (uniqueIdentifier == null) {
            return null;
        }
        return NSSItem.create(uniqueIdentifier.toString(), damage);
    }

    public static NormalizedSimpleStack create(String itemName, int damage) {
        Set<Object> usedMetadata;
        NSSItem normStack;
        try {
            normStack = new NSSItem(itemName, damage);
        }
        catch (Exception e) {
            PECore.LOGGER.fatal("Could not create NSSItem: {}", (Object)e.getMessage());
            return null;
        }
        if (!idWithUsedMetaData.containsKey(normStack.itemName)) {
            usedMetadata = new HashSet();
            idWithUsedMetaData.put(normStack.itemName, usedMetadata);
        } else {
            usedMetadata = idWithUsedMetaData.get(normStack.itemName);
        }
        usedMetadata.add(normStack.damage);
        return normStack;
    }

    public static Set<Integer> getUsedMetadata(NormalizedSimpleStack nss) {
        if (nss instanceof NSSItem) {
            return idWithUsedMetaData.getOrDefault(((NSSItem)nss).itemName, (Set<Integer>)ImmutableSet.of());
        }
        throw new IllegalArgumentException("Can only get Metadata for Items!");
    }

    public int hashCode() {
        return this.itemName.hashCode() ^ this.damage;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NSSItem) {
            NSSItem other = (NSSItem)obj;
            return this.itemName.equals(other.itemName) && this.damage == other.damage;
        }
        return false;
    }

    @Override
    public String json() {
        return String.format("%s|%s", this.itemName, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
    }

    public String toString() {
        Item obj = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.itemName));
        if (obj != null) {
            return String.format("%s(%s:%s)", this.itemName, Item.field_150901_e.func_148757_b((Object)obj), this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
        }
        return String.format("%s(???:%s)", this.itemName, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
    }
}

