/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.Sets;
import java.util.Set;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    private static final Set<String> BLACKLIST_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"dustPlastic"});

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        if (config.getBoolean("blacklistOresAndDusts", "", true, "Set EMC=0 for everything that has an OD Name that starts with `ore`, `dust` or `crushed` besides `dustPlastic`")) {
            for (String s : OreDictionary.getOreNames()) {
                if (s == null || !s.startsWith("ore") && !s.startsWith("dust") && !s.startsWith("crushed") || BLACKLIST_EXCEPTIONS.contains(s)) continue;
                for (ItemStack stack : ItemHelper.getODItems(s)) {
                    if (stack.func_190926_b()) continue;
                    mapper.setValueBefore(NSSItem.create(stack), 0);
                    mapper.setValueAfter(NSSItem.create(stack), 0);
                }
            }
        }
    }

    @Override
    public String getName() {
        return "OreDictionaryMapper";
    }

    @Override
    public String getDescription() {
        return "Blacklist some OreDictionary names from getting an EMC value";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

