/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSFake;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NSSOreDictionary;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.emc.mappers.customConversions.json.ConversionGroup;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionDeserializer;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionFile;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValues;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValuesDeserializer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.IOUtils;

public class CustomConversionMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    private static final String EXAMPLE_FILENAME = "example";
    private static final ImmutableList<String> defaultFilenames = ImmutableList.of((Object)"defaults", (Object)"ODdefaults", (Object)"metals");
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomConversion.class, (Object)new CustomConversionDeserializer()).registerTypeAdapter(FixedValues.class, (Object)new FixedValuesDeserializer()).registerTypeAdapter(NormalizedSimpleStack.class, (Object)NormalizedSimpleStack.Serializer.INSTANCE).setPrettyPrinting().create();

    @Override
    public String getName() {
        return "CustomConversionMapper";
    }

    @Override
    public String getDescription() {
        return "Uses json files within config/ProjectE/customConversions/ to add values and conversions";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        File customConversionFolder = CustomConversionMapper.getCustomConversionFolder();
        if (customConversionFolder.isDirectory() || customConversionFolder.mkdir()) {
            CustomConversionMapper.tryToWriteDefaultFiles();
            for (String defaultFile : defaultFilenames) {
                CustomConversionMapper.readFile(new File(customConversionFolder, defaultFile + ".json"), config, mapper, true);
            }
            List<File> sortedFiles = Arrays.asList(customConversionFolder.listFiles());
            Collections.sort(sortedFiles);
            for (File f : sortedFiles) {
                CustomConversionMapper.readFile(f, config, mapper, false);
            }
            NSSFake.resetNamespace();
        } else {
            PECore.LOGGER.fatal("COULD NOT CREATE customConversions FOLDER IN config/ProjectE");
        }
    }

    private static void readFile(File f, Configuration config, IMappingCollector<NormalizedSimpleStack, Integer> mapper, boolean allowDefaults) {
        String name;
        if (f.isFile() && f.canRead() && f.getName().toLowerCase().endsWith(".json") && !EXAMPLE_FILENAME.equals(name = f.getName().substring(0, f.getName().length() - ".json".length())) && (allowDefaults || !defaultFilenames.contains((Object)name)) && config.getBoolean(name, "", true, String.format("Read file: %s?", f.getName()))) {
            try {
                NSSFake.setCurrentNamespace(name);
                CustomConversionMapper.addMappingsFromFile(new FileReader(f), mapper);
                PECore.LOGGER.info("Collected Mappings from {}", (Object)f.getName());
            }
            catch (Exception e) {
                PECore.LOGGER.fatal("Exception when reading file: {}", (Object)f);
                e.printStackTrace();
            }
        }
    }

    private static File getCustomConversionFolder() {
        return new File(PECore.CONFIG_DIR, "customConversions");
    }

    private static void addMappingsFromFile(Reader json, IMappingCollector<NormalizedSimpleStack, Integer> mapper) {
        CustomConversionMapper.addMappingsFromFile(CustomConversionMapper.parseJson(json), mapper);
    }

    private static void addMappingsFromFile(CustomConversionFile file, IMappingCollector<NormalizedSimpleStack, Integer> mapper) {
        for (Map.Entry<String, ConversionGroup> entry : file.groups.entrySet()) {
            PECore.LOGGER.info("Adding conversions from group '{}' with comment '{}'", (Object)entry.getKey(), (Object)entry.getValue().comment);
            try {
                for (CustomConversion conversion : entry.getValue().conversions) {
                    mapper.addConversion(conversion.count, conversion.output, conversion.ingredients);
                }
            }
            catch (Exception e) {
                PECore.LOGGER.fatal("ERROR reading custom conversion from group {}!", (Object)entry.getKey());
                e.printStackTrace();
            }
        }
        try {
            String odName;
            NormalizedSimpleStack something;
            if (file.values.setValueBefore != null) {
                for (Map.Entry<Object, Object> entry : file.values.setValueBefore.entrySet()) {
                    something = (NormalizedSimpleStack)entry.getKey();
                    mapper.setValueBefore(something, (Integer)((Comparable)entry.getValue()));
                    if (!(something instanceof NSSOreDictionary)) continue;
                    odName = ((NSSOreDictionary)something).od;
                    for (ItemStack itemStack : OreDictionary.getOres((String)odName)) {
                        mapper.setValueBefore(NSSItem.create(itemStack), (Integer)((Comparable)entry.getValue()));
                    }
                }
            }
            if (file.values.setValueAfter != null) {
                for (Map.Entry entry : file.values.setValueAfter.entrySet()) {
                    something = (NormalizedSimpleStack)entry.getKey();
                    mapper.setValueAfter(something, (Integer)((Comparable)entry.getValue()));
                    if (!(something instanceof NSSOreDictionary)) continue;
                    odName = ((NSSOreDictionary)something).od;
                    for (ItemStack itemStack : OreDictionary.getOres((String)odName)) {
                        mapper.setValueAfter(NSSItem.create(itemStack), (Integer)((Comparable)entry.getValue()));
                    }
                }
            }
            if (file.values.conversion != null) {
                for (CustomConversion customConversion : file.values.conversion) {
                    NormalizedSimpleStack out = customConversion.output;
                    if (customConversion.evalOD && out instanceof NSSOreDictionary) {
                        odName = ((NSSOreDictionary)out).od;
                        for (ItemStack itemStack : OreDictionary.getOres((String)odName)) {
                            mapper.setValueFromConversion(customConversion.count, NSSItem.create(itemStack), customConversion.ingredients);
                        }
                    }
                    mapper.setValueFromConversion(customConversion.count, out, customConversion.ingredients);
                }
            }
        }
        catch (Exception e) {
            PECore.LOGGER.fatal("ERROR reading custom conversion values!");
            e.printStackTrace();
        }
    }

    public static CustomConversionFile parseJson(Reader json) {
        return (CustomConversionFile)GSON.fromJson((Reader)new BufferedReader(json), CustomConversionFile.class);
    }

    private static void tryToWriteDefaultFiles() {
        CustomConversionMapper.writeDefaultFile(EXAMPLE_FILENAME);
        for (String filename : defaultFilenames) {
            CustomConversionMapper.writeDefaultFile(filename);
        }
    }

    private static void writeDefaultFile(String filename) {
        block27: {
            File f = new File(CustomConversionMapper.getCustomConversionFolder(), filename + ".json");
            if (f.exists()) {
                f.delete();
            }
            try {
                if (!f.createNewFile() || !f.canWrite()) break block27;
                String path = "defaultCustomConversions/" + filename + ".json";
                try (InputStream stream = CustomConversionMapper.class.getClassLoader().getResourceAsStream(path);
                     BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(f));){
                    IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

