/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.AlchBagImpl;
import moze_intel.projecte.impl.KnowledgeImpl;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.CheckUpdatePKT;
import moze_intel.projecte.network.packets.SyncCovalencePKT;
import moze_intel.projecte.utils.AchievementHandler;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone evt) {
        NBTTagCompound bags = (NBTTagCompound)((IAlchBagProvider)evt.getOriginal().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).serializeNBT();
        ((IAlchBagProvider)evt.getEntityPlayer().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).deserializeNBT((NBTBase)bags);
        NBTTagCompound knowledge = (NBTTagCompound)((IKnowledgeProvider)evt.getOriginal().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).serializeNBT();
        ((IKnowledgeProvider)evt.getEntityPlayer().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).deserializeNBT((NBTBase)knowledge);
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent evt) {
        ((IKnowledgeProvider)evt.player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).sync((EntityPlayerMP)evt.player);
        ((IAlchBagProvider)evt.player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).sync(null, (EntityPlayerMP)evt.player);
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ((IKnowledgeProvider)event.player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).sync((EntityPlayerMP)event.player);
        ((IAlchBagProvider)event.player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).sync(null, (EntityPlayerMP)event.player);
        ((InternalAbilities)event.player.getCapability(InternalAbilities.CAPABILITY, null)).onDimensionChange();
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(AlchBagImpl.Provider.NAME, (ICapabilityProvider)new AlchBagImpl.Provider());
            evt.addCapability(KnowledgeImpl.Provider.NAME, (ICapabilityProvider)new KnowledgeImpl.Provider());
            if (evt.getObject() instanceof EntityPlayerMP) {
                evt.addCapability(InternalTimers.NAME, (ICapabilityProvider)new InternalTimers.Provider());
                evt.addCapability(InternalAbilities.NAME, (ICapabilityProvider)new InternalAbilities.Provider((EntityPlayerMP)evt.getObject()));
            }
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PacketHandler.sendFragmentedEmcPacket(player);
        PacketHandler.sendTo(new CheckUpdatePKT(), player);
        IKnowledgeProvider knowledge = (IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null);
        knowledge.sync(player);
        PlayerHelper.updateScore(player, AchievementHandler.SCOREBOARD_EMC, MathHelper.func_76128_c((double)knowledge.getEmc()));
        ((IAlchBagProvider)player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).sync(null, player);
        PacketHandler.sendTo(new SyncCovalencePKT(ProjectEConfig.difficulty.covalenceLoss), player);
        PECore.LOGGER.info("Sent knowledge and bag data to {}", (Object)player.func_70005_c_());
    }

    @SubscribeEvent
    public static void onConstruct(EntityEvent.EntityConstructing evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && evt.getEntity() instanceof EntityPlayer && !(evt.getEntity() instanceof FakePlayer)) {
            TransmutationOffline.clear(evt.getEntity().func_110124_au());
            PECore.debugLog("Clearing offline data cache in preparation to load online data", new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onHighAlchemistJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (PECore.uuids.contains(evt.player.func_110124_au().toString())) {
            ITextComponent prior = new TextComponentTranslation("pe.server.high_alchemist", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE));
            ITextComponent playername = new TextComponentString(" " + evt.player.func_70005_c_() + " ").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD));
            ITextComponent latter = new TextComponentTranslation("pe.server.has_joined", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE));
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a(prior.func_150257_a(playername).func_150257_a(latter));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void pickupItem(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, (NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        if (bag.func_190926_b()) {
            return;
        }
        IItemHandler handler = ((IAlchBagProvider)player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).getBag(EnumDyeColor.func_176764_b((int)bag.func_77952_i()));
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)event.getItem().func_92059_d(), (boolean)false);
        if (remainder.func_190926_b()) {
            event.getItem().func_70106_y();
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketCollectItem(event.getItem().func_145782_y(), player.func_145782_y(), 1));
        } else {
            event.getItem().func_92058_a(remainder);
        }
        event.setCanceled(true);
    }
}

