/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.EnumSet;
import java.util.Set;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.item.IAlchBagItem;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class TickEvents {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            IAlchBagProvider provider = (IAlchBagProvider)event.player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null);
            EnumSet<EnumDyeColor> colorsChanged = EnumSet.noneOf(EnumDyeColor.class);
            for (EnumDyeColor color : TickEvents.getBagColorsPresent(event.player)) {
                IItemHandler inv = provider.getBag(color);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack current = inv.getStackInSlot(i);
                    if (current.func_190926_b() || !(current.func_77973_b() instanceof IAlchBagItem) || !((IAlchBagItem)current.func_77973_b()).updateInAlchBag(inv, event.player, current)) continue;
                    colorsChanged.add(color);
                }
            }
            if (!event.player.func_130014_f_().field_72995_K) {
                for (EnumDyeColor e : colorsChanged) {
                    if (event.player.field_71070_bA instanceof AlchBagContainer && event.player.func_184586_b(((AlchBagContainer)event.player.field_71070_bA).hand).func_77952_i() == e.func_176765_a()) continue;
                    provider.sync(e, (EntityPlayerMP)event.player);
                }
                ((InternalAbilities)event.player.getCapability(InternalAbilities.CAPABILITY, null)).tick();
                ((InternalTimers)event.player.getCapability(InternalTimers.CAPABILITY, null)).tick();
            }
        }
    }

    private static Set<EnumDyeColor> getBagColorsPresent(EntityPlayer player) {
        EnumSet<EnumDyeColor> bagsPresent = EnumSet.noneOf(EnumDyeColor.class);
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ObjHandler.alchBag) continue;
            bagsPresent.add(EnumDyeColor.func_176764_b((int)stack.func_77952_i()));
        }
        return bagsPresent;
    }
}

