/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK3Tile;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Collector
extends BlockDirection {
    private final int tier;

    public Collector(int tier) {
        super(Material.field_151592_s);
        this.func_149663_c("pe_collector_MK" + tier);
        this.func_149715_a(Constants.COLLECTOR_LIGHT_VALS[tier - 1]);
        this.func_149711_c(0.3f);
        this.tier = tier;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.field_72995_K) {
            switch (this.tier) {
                case 1: {
                    player.openGui((Object)PECore.instance, 6, world, x, y, z);
                    break;
                }
                case 2: {
                    player.openGui((Object)PECore.instance, 7, world, x, y, z);
                    break;
                }
                case 3: {
                    player.openGui((Object)PECore.instance, 8, world, x, y, z);
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch (this.tier) {
            case 3: {
                return new CollectorMK3Tile();
            }
            case 2: {
                return new CollectorMK2Tile();
            }
            case 1: {
                return new CollectorMK1Tile();
            }
        }
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        CollectorMK1Tile tile = (CollectorMK1Tile)world.func_175625_s(pos);
        ItemStack charging = ((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)).getStackInSlot(0);
        if (!charging.func_190926_b()) {
            if (charging.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)charging.func_77973_b();
                double max = itemEmc.getMaximumEmc(charging);
                double current = itemEmc.getStoredEmc(charging);
                return MathUtils.scaleToRedstone(current, max);
            }
            double needed = tile.getEmcToNextGoal();
            double current = tile.getStoredEmc();
            return MathUtils.scaleToRedstone(current, needed);
        }
        return MathUtils.scaleToRedstone(tile.getStoredEmc(), tile.getMaximumEmc());
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity ent = world.func_175625_s(pos);
        IItemHandler handler = (IItemHandler)ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (i == 2 || handler.getStackInSlot(i).func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
        }
        super.func_180663_b(world, pos, state);
    }
}

