/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Pedestal
extends Block {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);

    public Pedestal() {
        super(Material.field_151576_e);
        this.func_149647_a(ObjHandler.cTab);
        this.func_149711_c(1.0f);
        this.func_149663_c("pe_dmPedestal");
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    private void dropItem(World world, BlockPos pos) {
        DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
        ItemStack stack = tile.getInventory().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            WorldHelper.spawnEntityItem(world, stack, pos.func_177958_n(), (double)pos.func_177956_o() + 0.8, pos.func_177952_p());
            tile.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.dropItem(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.dropItem(world, pos);
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 8);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            ItemStack item = tile.getInventory().getStackInSlot(0);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190926_b() && !item.func_190926_b() && item.func_77973_b() instanceof IPedestalItem) {
                tile.setActive(!tile.getActive());
                world.func_184138_a(pos, state, state, 8);
            } else if (!stack.func_190926_b() && item.func_190926_b()) {
                tile.getInventory().setStackInSlot(0, stack.func_77979_a(1));
                if (stack.func_190916_E() <= 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                world.func_184138_a(pos, state, state, 8);
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos neighborPos) {
        boolean flag = world.func_175640_z(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DMPedestalTile) {
            DMPedestalTile ped = (DMPedestalTile)te;
            if (ped.previousRedstoneState != flag) {
                if (flag && !ped.getInventory().getStackInSlot(0).func_190926_b() && ped.getInventory().getStackInSlot(0).func_77973_b() instanceof IPedestalItem) {
                    ped.setActive(!ped.getActive());
                    world.func_184138_a(pos, state, state, 11);
                }
                ped.previousRedstoneState = flag;
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        return 12;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new DMPedestalTile();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        tooltip.add(I18n.func_135052_a((String)"pe.pedestal.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"pe.pedestal.tooltip2", (Object[])new Object[0]));
    }
}

