/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK2Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK3Tile;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Relay
extends BlockDirection {
    private final int tier;

    public Relay(int tier) {
        super(Material.field_151576_e);
        this.func_149663_c("pe_relay_MK" + Integer.toString(tier));
        this.func_149715_a(Constants.COLLECTOR_LIGHT_VALS[tier - 1]);
        this.func_149711_c(10.0f);
        this.tier = tier;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            switch (this.tier) {
                case 1: {
                    player.openGui((Object)PECore.instance, 9, world, x, y, z);
                    break;
                }
                case 2: {
                    player.openGui((Object)PECore.instance, 10, world, x, y, z);
                    break;
                }
                case 3: {
                    player.openGui((Object)PECore.instance, 11, world, x, y, z);
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch (this.tier) {
            case 1: {
                return new RelayMK1Tile();
            }
            case 2: {
                return new RelayMK2Tile();
            }
            case 3: {
                return new RelayMK3Tile();
            }
        }
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        RelayMK1Tile relay = (RelayMK1Tile)world.func_175625_s(pos);
        return MathUtils.scaleToRedstone(relay.getStoredEmc(), relay.getMaximumEmc());
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        WorldHelper.dropInventory((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN), world, pos);
        super.func_180663_b(world, pos, state);
    }
}

