/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.container.slots.SlotCondenserLock;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserContainer
extends Container {
    final CondenserTile tile;
    public int displayEmc;
    public int requiredEmc;

    public CondenserContainer(InventoryPlayer invPlayer, CondenserTile condenser) {
        this.tile = condenser;
        ++this.tile.numPlayersUsing;
        this.initSlots(invPlayer);
    }

    void initSlots(InventoryPlayer invPlayer) {
        int j;
        int i;
        this.func_75146_a((Slot)new SlotCondenserLock((IItemHandler)this.tile.getLock(), 0, 12, 6));
        ItemStackHandler handler = this.tile.getInput();
        int counter = 0;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 13; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot((IItemHandler)handler, counter++, 12 + j * 18, 26 + i * 18, s -> SlotPredicates.HAS_EMC.test((ItemStack)s) && !this.tile.isStackEqualToLock((ItemStack)s)));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 48 + j * 18, 154 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 48 + i * 18, 212));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        PacketHandler.sendProgressBarUpdateInt(listener, this, 0, this.tile.displayEmc);
        PacketHandler.sendProgressBarUpdateInt(listener, this, 1, this.tile.requiredEmc);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.displayEmc != this.tile.displayEmc) {
            for (IContainerListener listener : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(listener, this, 0, this.tile.displayEmc);
            }
            this.displayEmc = this.tile.displayEmc;
        }
        if (this.requiredEmc != this.tile.requiredEmc) {
            for (IContainerListener listener : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(listener, this, 1, this.tile.requiredEmc);
            }
            this.requiredEmc = this.tile.requiredEmc;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.displayEmc = data;
                break;
            }
            case 1: {
                this.requiredEmc = data;
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex <= 91 ? !this.func_75135_a(stack, 92, 127, false) : !EMCHelper.doesItemHaveEmc(stack) || !this.func_75135_a(stack, 1, 91, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, stack);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        --this.tile.numPlayersUsing;
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int button, ClickType flag, EntityPlayer player) {
        if (slot == 0 && !this.tile.getLock().getStackInSlot(0).func_190926_b()) {
            if (!player.func_130014_f_().field_72995_K) {
                this.tile.getLock().setStackInSlot(0, ItemStack.field_190927_a);
                this.func_75142_b();
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, button, flag, player);
    }

    public int getProgressScaled() {
        if (this.requiredEmc == 0) {
            return 0;
        }
        if (this.displayEmc >= this.requiredEmc) {
            return 102;
        }
        return this.displayEmc * 102 / this.requiredEmc;
    }
}

