/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class Ignition
extends RingToggle
implements IBauble,
IPedestalItem,
IFireProtector,
IProjectileShooter {
    public Ignition() {
        super("ignition");
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int inventorySlot, boolean par5) {
        if (world.field_72995_K || inventorySlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, inventorySlot, par5);
        EntityPlayerMP player = (EntityPlayerMP)entity;
        if (stack.func_77952_i() != 0) {
            if (Ignition.getEmc(stack) == 0.0 && !Ignition.consumeFuel((EntityPlayer)player, stack, 64.0, false)) {
                stack.func_77964_b(0);
            } else {
                WorldHelper.igniteNearby(world, (EntityPlayer)player);
                Ignition.removeEmc(stack, 0.32f);
            }
        } else {
            WorldHelper.extinguishNearby(world, (EntityPlayer)player);
        }
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        if (stack.func_77952_i() == 0) {
            if (Ignition.getEmc(stack) != 0.0 || Ignition.consumeFuel(player, stack, 64.0, false)) {
                stack.func_77964_b(1);
            }
        } else {
            stack.func_77964_b(0);
        }
        return true;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockTNT) {
            if (!world.field_72995_K && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) {
                ((BlockTNT)state.func_177230_c()).func_180692_a(world, pos, state.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)player);
                world.func_175698_g(pos);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.POWER, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.func_130014_f_(), (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.ignitePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                List list = world.func_72872_a(EntityLiving.class, tile.getEffectBounds());
                for (EntityLiving living : list) {
                    living.func_70097_a(DamageSource.field_76372_a, 3.0f);
                    living.func_70015_d(8);
                }
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.ignitePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (ProjectEConfig.pedestalCooldown.ignitePedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.ignition.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.ignition.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.ignitePedCooldown)}));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        EntityFireProjectile fire = new EntityFireProjectile(world, player);
        fire.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_72838_d((Entity)fire);
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

