/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.tools.PEToolBase;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class RedStar
extends PEToolBase {
    public RedStar() {
        super("rm_morning_star", (byte)4, new String[]{"pe.morningstar.mode1", "pe.morningstar.mode2", "pe.morningstar.mode3", "pe.morningstar.mode4"});
        this.setNoRepair();
        this.peToolMaterial = "rm_tools";
        this.harvestMaterials.add(Material.field_151577_b);
        this.harvestMaterials.add(Material.field_151578_c);
        this.harvestMaterials.add(Material.field_151595_p);
        this.harvestMaterials.add(Material.field_151597_y);
        this.harvestMaterials.add(Material.field_151571_B);
        this.harvestMaterials.add(Material.field_151573_f);
        this.harvestMaterials.add(Material.field_151574_g);
        this.harvestMaterials.add(Material.field_151576_e);
        this.harvestMaterials.add(Material.field_151575_d);
        this.harvestMaterials.add(Material.field_151585_k);
        this.harvestMaterials.add(Material.field_151582_l);
        this.toolClasses.add("morning_star");
        this.toolClasses.add("pickaxe");
        this.toolClasses.add("chisel");
        this.toolClasses.add("shovel");
        this.toolClasses.add("axe");
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase damaged, EntityLivingBase damager) {
        this.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase eLiving) {
        this.digBasedOnMode(stack, world, state.func_177230_c(), pos, eLiving);
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            RayTraceResult mop;
            if (ProjectEConfig.items.pickaxeAoeVeinMining) {
                this.mineOreVeinsInAOE(stack, player, hand);
            }
            if ((mop = this.func_77621_a(world, player, true)) == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState state = world.func_180495_p(mop.func_178782_a());
                Block block = state.func_177230_c();
                if (block instanceof BlockGravel || block instanceof BlockClay) {
                    if (ProjectEConfig.items.pickaxeAoeVeinMining) {
                        this.digAOE(stack, world, player, false, 0, hand);
                    } else {
                        this.tryVeinMine(stack, player, mop);
                    }
                } else if (ItemHelper.isOre(state)) {
                    if (!ProjectEConfig.items.pickaxeAoeVeinMining) {
                        this.tryVeinMine(stack, player, mop);
                    }
                } else if (block instanceof BlockGrass || block instanceof BlockDirt || block instanceof BlockSand) {
                    this.digAOE(stack, world, player, false, 0, hand);
                } else {
                    this.digAOE(stack, world, player, true, 0, hand);
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == ObjHandler.matterBlock || block == ObjHandler.dmFurnaceOff || block == ObjHandler.dmFurnaceOn || block == ObjHandler.rmFurnaceOff || block == ObjHandler.rmFurnaceOn) {
            return 1200000.0f;
        }
        return super.func_150893_a(stack, state) + 48.0f;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        byte charge = this.getCharge(stack);
        float damage = 20.0f + (float)charge;
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        return multimap;
    }
}

