/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.proxy.IBlacklistProxy;
import moze_intel.projecte.gameObjs.items.TimeWatch;
import moze_intel.projecte.utils.NBTWhitelist;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class BlacklistProxyImpl
implements IBlacklistProxy {
    public static final IBlacklistProxy instance = new BlacklistProxyImpl();

    private BlacklistProxyImpl() {
    }

    @Override
    public void blacklistInterdiction(@Nonnull Class<? extends Entity> clazz) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.POSTINITIALIZATION), (String)"Mod %s registering interdiction blacklist at incorrect time!", (Object)Loader.instance().activeModContainer().getModId());
        this.doBlacklistInterdiction(clazz, Loader.instance().activeModContainer().getModId());
    }

    @Override
    public void blacklistSwiftwolf(@Nonnull Class<? extends Entity> clazz) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.POSTINITIALIZATION), (String)"Mod %s registering SWRG repel at incorrect time!", (Object)Loader.instance().activeModContainer().getModId());
        this.doBlacklistSwiftwolf(clazz, Loader.instance().activeModContainer().getModId());
    }

    @Override
    public void blacklistTimeWatch(@Nonnull Class<? extends TileEntity> clazz) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.POSTINITIALIZATION), (String)"Mod %s registering TimeWatch blacklist at incorrect time!", (Object)Loader.instance().activeModContainer().getModId());
        this.doBlacklistTimewatch(clazz, Loader.instance().activeModContainer().getModId());
    }

    @Override
    public void whitelistNBT(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack);
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.POSTINITIALIZATION), (String)"Mod %s registering NBT whitelist at incorrect time!", (Object)Loader.instance().activeModContainer().getModId());
        this.doWhitelistNBT(stack, Loader.instance().activeModContainer().getModId());
    }

    protected void doBlacklistInterdiction(Class<? extends Entity> clazz, String modName) {
        WorldHelper.blacklistInterdiction(clazz);
        PECore.LOGGER.info("Mod {} blacklisted {} for interdiction torch", (Object)modName, (Object)clazz.getCanonicalName());
    }

    protected void doBlacklistSwiftwolf(Class<? extends Entity> clazz, String modName) {
        WorldHelper.blacklistSwrg(clazz);
        PECore.LOGGER.info("Mod {} blacklisted {} for SWRG repel", (Object)modName, (Object)clazz.getCanonicalName());
    }

    protected void doBlacklistTimewatch(Class<? extends TileEntity> clazz, String modName) {
        TimeWatch.blacklist(clazz);
        PECore.LOGGER.info("Mod {} blacklisted {} for Time Watch acceleration", (Object)modName, (Object)clazz.getCanonicalName());
    }

    protected void doWhitelistNBT(ItemStack s, String modName) {
        NBTWhitelist.register(s);
        PECore.LOGGER.info("Mod {} whitelisted {} for NBT duping", (Object)modName, (Object)s.toString());
    }
}

