/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.network.packets.CheckUpdatePKT;
import moze_intel.projecte.network.packets.CooldownResetPKT;
import moze_intel.projecte.network.packets.KeyPressPKT;
import moze_intel.projecte.network.packets.KnowledgeClearPKT;
import moze_intel.projecte.network.packets.KnowledgeSyncPKT;
import moze_intel.projecte.network.packets.LeftClickArchangelPKT;
import moze_intel.projecte.network.packets.SearchUpdatePKT;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.network.packets.SyncBagDataPKT;
import moze_intel.projecte.network.packets.SyncCovalencePKT;
import moze_intel.projecte.network.packets.SyncEmcPKT;
import moze_intel.projecte.network.packets.UpdateGemModePKT;
import moze_intel.projecte.network.packets.UpdateWindowIntPKT;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class PacketHandler {
    private static final int MAX_PKT_SIZE = 256;
    private static final SimpleNetworkWrapper HANDLER = NetworkRegistry.INSTANCE.newSimpleChannel("projecte");

    public static void register() {
        int disc = 0;
        HANDLER.registerMessage(SyncEmcPKT.Handler.class, SyncEmcPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(KeyPressPKT.Handler.class, KeyPressPKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(StepHeightPKT.Handler.class, StepHeightPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(SetFlyPKT.Handler.class, SetFlyPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(KnowledgeSyncPKT.Handler.class, KnowledgeSyncPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(CheckUpdatePKT.Handler.class, CheckUpdatePKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(SyncBagDataPKT.Handler.class, SyncBagDataPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(SearchUpdatePKT.Handler.class, SearchUpdatePKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(KnowledgeClearPKT.Handler.class, KnowledgeClearPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(UpdateGemModePKT.Handler.class, UpdateGemModePKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(UpdateWindowIntPKT.Handler.class, UpdateWindowIntPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(CooldownResetPKT.Handler.class, CooldownResetPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(LeftClickArchangelPKT.Handler.class, LeftClickArchangelPKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(SyncCovalencePKT.Handler.class, SyncCovalencePKT.class, disc++, Side.CLIENT);
    }

    public static void sendProgressBarUpdateInt(IContainerListener listener, Container container, int propId, int propVal) {
        if (listener instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new UpdateWindowIntPKT((short)container.field_75152_c, (short)propId, propVal), (EntityPlayerMP)listener);
        }
    }

    public static void sendFragmentedEmcPacket(EntityPlayerMP player) {
        ArrayList<Integer[]> list = new ArrayList<Integer[]>();
        int counter = 0;
        for (Map.Entry<SimpleStack, Integer> entry : new LinkedHashMap<SimpleStack, Integer>(EMCMapper.emc).entrySet()) {
            SimpleStack stack = entry.getKey();
            if (stack == null) continue;
            int id = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)stack.id));
            Integer[] data = new Integer[]{id, stack.damage, entry.getValue()};
            list.add(data);
            if (list.size() < 256) continue;
            PacketHandler.sendTo(new SyncEmcPKT(counter, list), player);
            list.clear();
            ++counter;
        }
        if (list.size() > 0) {
            PacketHandler.sendTo(new SyncEmcPKT(-1, list), player);
            list.clear();
            ++counter;
        }
        PECore.LOGGER.info("Sent EMC data packets to: {}", (Object)player.func_70005_c_());
        PECore.debugLog("Total packets: {}", counter);
    }

    public static void sendFragmentedEmcPacketToAll() {
        ArrayList<Integer[]> list = new ArrayList<Integer[]>();
        int counter = 0;
        for (Map.Entry<SimpleStack, Integer> entry : new LinkedHashMap<SimpleStack, Integer>(EMCMapper.emc).entrySet()) {
            SimpleStack stack = entry.getKey();
            if (stack == null) continue;
            int id = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)stack.id));
            Integer[] data = new Integer[]{id, stack.damage, entry.getValue()};
            list.add(data);
            if (list.size() < 256) continue;
            PacketHandler.sendToAll(new SyncEmcPKT(counter, list));
            list.clear();
            ++counter;
        }
        if (list.size() > 0) {
            PacketHandler.sendToAll(new SyncEmcPKT(-1, list));
            list.clear();
            ++counter;
        }
        PECore.LOGGER.info("Sent EMC data packets to all players.");
        PECore.debugLog("Total packets per player: {}", counter);
    }

    public static void sendToServer(IMessage msg) {
        HANDLER.sendToServer(msg);
    }

    public static void sendToAll(IMessage msg) {
        HANDLER.sendToAll(msg);
    }

    public static void sendToAllAround(IMessage msg, NetworkRegistry.TargetPoint point) {
        HANDLER.sendToAllAround(msg, point);
    }

    public static void sendTo(IMessage msg, EntityPlayerMP player) {
        if (!(player instanceof FakePlayer)) {
            HANDLER.sendTo(msg, player);
        }
    }

    public static void sendToDimension(IMessage msg, int dimension) {
        HANDLER.sendToDimension(msg, dimension);
    }
}

