/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.playerData.Transmutation;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncEmcPKT
implements IMessage {
    private int packetNum;
    private Object[] data;

    public SyncEmcPKT() {
    }

    public SyncEmcPKT(int packetNum, List<Integer[]> arrayList) {
        this.packetNum = packetNum;
        this.data = arrayList.toArray();
    }

    public void fromBytes(ByteBuf buf) {
        this.packetNum = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        int size = buf.readShort();
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            Integer[] array = new Integer[4];
            for (int j = 0; j < 3; ++j) {
                array[j] = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
            }
            this.data[i] = array;
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.packetNum, (int)5);
        buf.writeShort(this.data.length);
        for (Object obj : this.data) {
            Integer[] array = (Integer[])obj;
            for (int i = 0; i < 3; ++i) {
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)array[i], (int)5);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<SyncEmcPKT, IMessage> {
        public IMessage onMessage(final SyncEmcPKT pkt, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (pkt.packetNum == 0) {
                        PECore.LOGGER.info("Receiving EMC data from server.");
                        EMCMapper.emc.clear();
                    }
                    for (Object obj : pkt.data) {
                        Integer[] array = (Integer[])obj;
                        Item i = (Item)Item.field_150901_e.func_148754_a(array[0].intValue());
                        SimpleStack stack = new SimpleStack(i.getRegistryName(), array[1]);
                        if (!stack.isValid()) continue;
                        EMCMapper.emc.put(stack, array[2]);
                    }
                    if (pkt.packetNum == -1) {
                        PECore.LOGGER.info("Received all packets!");
                        Transmutation.cacheFullKnowledge();
                        FuelMapper.loadMap();
                    }
                }
            });
            return null;
        }
    }
}

