/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableMap;
import java.text.DecimalFormat;

public final class Constants {
    public static final DecimalFormat EMC_FORMATTER = new DecimalFormat("#,###.##");
    public static final float PLAYER_WALK_SPEED = 0.1f;
    public static final int[] MAX_KLEIN_EMC = new int[]{50000, 200000, 800000, 3200000, 12800000, 51200000};
    public static final int[] RELAY_KLEIN_CHARGE_RATE = new int[]{16, 48, 160};
    public static final float[] COLLECTOR_LIGHT_VALS = new float[]{0.4375f, 0.6875f, 1.0f};
    public static final float[] EXPLOSIVE_LENS_RADIUS = new float[]{4.0f, 8.0f, 12.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f};
    public static final int[] EXPLOSIVE_LENS_COST = new int[]{384, 768, 1536, 2304, 2304, 2304, 2304, 2304};
    public static final int TILE_MAX_EMC = 0x40000000;
    public static final int COLLECTOR_MK1_MAX = 10000;
    public static final int COLLECTOR_MK2_MAX = 30000;
    public static final int COLLECTOR_MK3_MAX = 60000;
    public static final int COLLECTOR_MK1_GEN = 4;
    public static final int COLLECTOR_MK2_GEN = 12;
    public static final int COLLECTOR_MK3_GEN = 40;
    public static final int RELAY_MK1_OUTPUT = 64;
    public static final int RELAY_MK2_OUTPUT = 192;
    public static final int RELAY_MK3_OUTPUT = 640;
    public static final int RELAY_MK1_MAX = 100000;
    public static final int RELAY_MK2_MAX = 1000000;
    public static final int RELAY_MK3_MAX = 10000000;
    public static final int COAL_BURN_TIME = 1600;
    public static final int ALCH_BURN_TIME = 6400;
    public static final int MOBIUS_BURN_TIME = 25600;
    public static final int AETERNALIS_BURN_TIME = 102400;
    public static final int ALCH_CHEST_GUI = 0;
    public static final int ALCH_BAG_GUI = 1;
    public static final int TRANSMUTE_STONE_GUI = 2;
    public static final int CONDENSER_GUI = 3;
    public static final int RM_FURNACE_GUI = 4;
    public static final int DM_FURNACE_GUI = 5;
    public static final int COLLECTOR1_GUI = 6;
    public static final int COLLECTOR2_GUI = 7;
    public static final int COLLECTOR3_GUI = 8;
    public static final int RELAY1_GUI = 9;
    public static final int RELAY2_GUI = 10;
    public static final int RELAY3_GUI = 11;
    public static final int MERCURIAL_GUI = 12;
    public static final int PHILOS_STONE_GUI = 13;
    public static final int TRANSMUTATION_GUI = 14;
    public static final int ETERNAL_DENSITY_GUI = 15;
    public static final int CONDENSER_MK2_GUI = 16;
    public static final int MAX_CONDENSER_PROGRESS = 102;
    public static final int MAX_VEIN_SIZE = 250;
    public static final int ENCH_EMC_BONUS = 5000;
    public static final ImmutableMap<String, String> SPACE_STRIP_NAME_MAP;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"Alchemical Chest", (Object)"alchemical_chest");
        builder.put((Object)"Interdiction Torch", (Object)"interdiction_torch");
        builder.put((Object)"Transmutation Stone", (Object)"transmutation_table");
        builder.put((Object)"Condenser", (Object)"condenser_mk1");
        builder.put((Object)"Condenser MK2", (Object)"condenser_mk2");
        builder.put((Object)"RM Furnace", (Object)"rm_furnace");
        builder.put((Object)"RM Furnace Lit", (Object)"rm_furnace_lit");
        builder.put((Object)"DM Furnace", (Object)"dm_furnace");
        builder.put((Object)"DM Furnace Lit", (Object)"dm_furnace_lit");
        builder.put((Object)"DM Pedestal", (Object)"dm_pedestal");
        builder.put((Object)"Matter Block", (Object)"matter_block");
        builder.put((Object)"Fuel Block", (Object)"fuel_block");
        builder.put((Object)"Collector MK1", (Object)"collector_mk1");
        builder.put((Object)"Collector MK2", (Object)"collector_mk2");
        builder.put((Object)"Collector MK3", (Object)"collector_mk3");
        builder.put((Object)"Relay MK1", (Object)"relay_mk1");
        builder.put((Object)"Realy MK2", (Object)"relay_mk2");
        builder.put((Object)"Relay MK3", (Object)"relay_mk3");
        builder.put((Object)"Nova Catalyst", (Object)"nova_catalyst");
        builder.put((Object)"Nova Cataclysm", (Object)"nova_cataclysm");
        SPACE_STRIP_NAME_MAP = builder.build();
    }
}

