/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class EMCHelper {
    public static double consumePlayerFuel(EntityPlayer player, double minFuel) {
        if (player.field_71075_bZ.field_75098_d) {
            return minFuel;
        }
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        boolean metRequirement = false;
        int emcConsumed = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)stack.func_77973_b();
                if (!(itemEmc.getStoredEmc(stack) >= minFuel)) continue;
                itemEmc.extractEmc(stack, minFuel);
                player.field_71069_bz.func_75142_b();
                return minFuel;
            }
            if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
            int emc = EMCHelper.getEmcValue(stack);
            int toRemove = (int)Math.ceil((minFuel - (double)emcConsumed) / (double)emc);
            if (stack.func_190916_E() >= toRemove) {
                map.put(i, toRemove);
                emcConsumed += emc * toRemove;
                metRequirement = true;
                continue;
            }
            map.put(i, stack.func_190916_E());
            emcConsumed += emc * stack.func_190916_E();
            if (!((double)emcConsumed >= minFuel)) continue;
            metRequirement = true;
        }
        if (metRequirement) {
            for (Map.Entry entry : map.entrySet()) {
                inv.extractItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue(), false);
            }
            player.field_71069_bz.func_75142_b();
            return emcConsumed;
        }
        return -1.0;
    }

    public static boolean doesBlockHaveEmc(Block block) {
        return block != null && EMCHelper.doesItemHaveEmc(new ItemStack(block));
    }

    public static boolean doesItemHaveEmc(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        SimpleStack iStack = new SimpleStack(stack);
        if (!iStack.isValid()) {
            return false;
        }
        if (ItemHelper.isDamageable(stack)) {
            iStack = iStack.withMeta(0);
        }
        return EMCMapper.mapContains(iStack);
    }

    public static boolean doesItemHaveEmc(Item item) {
        return item != null && EMCHelper.doesItemHaveEmc(new ItemStack(item));
    }

    public static int getEmcValue(Block block) {
        SimpleStack stack = new SimpleStack(new ItemStack(block));
        if (stack.isValid() && EMCMapper.mapContains(stack)) {
            return EMCMapper.getEmcValue(stack);
        }
        return 0;
    }

    public static int getEmcValue(Item item) {
        SimpleStack stack = new SimpleStack(new ItemStack(item));
        if (stack.isValid() && EMCMapper.mapContains(stack)) {
            return EMCMapper.getEmcValue(stack);
        }
        return 0;
    }

    public static int getEmcValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        SimpleStack iStack = new SimpleStack(stack);
        if (!iStack.isValid()) {
            return 0;
        }
        if (!EMCMapper.mapContains(iStack) && ItemHelper.isDamageable(stack)) {
            if (EMCMapper.mapContains(iStack = iStack.withMeta(0))) {
                int emc = EMCMapper.getEmcValue(iStack);
                int relDamage = stack.func_77958_k() + 1 - stack.func_77952_i();
                if (relDamage <= 0) {
                    return emc;
                }
                long result = emc * relDamage;
                if (result <= 0L) {
                    return emc;
                }
                result /= (long)stack.func_77958_k();
                result += (long)EMCHelper.getEnchantEmcBonus(stack);
                if ((result = (long)((double)result + EMCHelper.getStoredEMCBonus(stack))) > Integer.MAX_VALUE) {
                    return emc;
                }
                if (result <= 0L) {
                    return 1;
                }
                return (int)result;
            }
        } else if (EMCMapper.mapContains(iStack)) {
            return EMCMapper.getEmcValue(iStack) + EMCHelper.getEnchantEmcBonus(stack) + (int)EMCHelper.getStoredEMCBonus(stack);
        }
        return 0;
    }

    private static int getEnchantEmcBonus(ItemStack stack) {
        int result = 0;
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchants.isEmpty()) {
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment ench = (Enchantment)entry.getKey();
                if (ench == null || ench.func_77324_c().func_185270_a() == 0) continue;
                result += 5000 / ench.func_77324_c().func_185270_a() * (Integer)entry.getValue();
            }
        }
        return result;
    }

    public static int getEmcSellValue(ItemStack stack) {
        double originalValue = EMCHelper.getEmcValue(stack);
        if (originalValue == 0.0) {
            return 0;
        }
        int emc = MathHelper.func_76128_c((double)(originalValue * EMCMapper.covalenceLoss));
        if (emc < 1) {
            emc = 1;
        }
        return emc;
    }

    public static String getEmcSellString(ItemStack stack, int stackSize) {
        if (EMCMapper.covalenceLoss == 1.0) {
            return " ";
        }
        int emc = EMCHelper.getEmcSellValue(stack);
        return " (" + Constants.EMC_FORMATTER.format(emc * stackSize) + ")";
    }

    public static int getKleinStarMaxEmc(ItemStack stack) {
        return Constants.MAX_KLEIN_EMC[stack.func_77952_i()];
    }

    private static double getStoredEMCBonus(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StoredEMC")) {
            return stack.func_77978_p().func_74769_h("StoredEMC");
        }
        return 0.0;
    }

    public static int getEMCPerDurability(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_77964_b(0);
        if (ItemHelper.isItemRepairable(stack)) {
            int emc = (int)Math.ceil(EMCHelper.getEmcValue(stackCopy) / stack.func_77958_k());
            return emc > 1 ? emc : 1;
        }
        return 1;
    }
}

