/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.world.Explosion;

public final class ReflectionHelper {
    private static final String[] arrowInGroundNames = new String[]{"inGround", "field_70254_i"};
    private static final String[] entityFireImmuneNames = new String[]{"isImmuneToFire", "field_70178_ae"};
    private static final String[] explosionSizeNames = new String[]{"size", "field_77280_f"};
    private static final String[] updateScorePointsNames = new String[]{"updateScorePoints", "func_184849_a"};
    private static final MethodHandle arrowInGround_getter;
    private static final MethodHandle explosionSize_getter;
    private static final MethodHandle explosionSize_setter;
    private static final MethodHandle fireImmunity_setter;
    private static final MethodHandle updateScorePoints;

    protected static boolean getArrowInGround(EntityArrow instance) {
        try {
            return arrowInGround_getter.invokeExact(instance);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected static float getExplosionSize(Explosion instance) {
        try {
            return explosionSize_getter.invokeExact(instance);
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    protected static void setEntityFireImmunity(Entity instance, boolean value) {
        try {
            fireImmunity_setter.invokeExact(instance, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void setExplosionSize(Explosion instance, float size) {
        try {
            explosionSize_setter.invokeExact(instance, size);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void updateScore(EntityPlayerMP player, IScoreCriteria objective, int score) {
        try {
            updateScorePoints.invokeExact(player, objective, score);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            Field f = net.minecraftforge.fml.relauncher.ReflectionHelper.findField(EntityArrow.class, (String[])arrowInGroundNames);
            f.setAccessible(true);
            arrowInGround_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = net.minecraftforge.fml.relauncher.ReflectionHelper.findField(Entity.class, (String[])entityFireImmuneNames);
            f.setAccessible(true);
            fireImmunity_setter = MethodHandles.publicLookup().unreflectSetter(f);
            f = net.minecraftforge.fml.relauncher.ReflectionHelper.findField(Explosion.class, (String[])explosionSizeNames);
            f.setAccessible(true);
            explosionSize_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = net.minecraftforge.fml.relauncher.ReflectionHelper.findField(Explosion.class, (String[])explosionSizeNames);
            f.setAccessible(true);
            explosionSize_setter = MethodHandles.publicLookup().unreflectSetter(f);
            Method m = net.minecraftforge.fml.relauncher.ReflectionHelper.findMethod(EntityPlayerMP.class, (String)updateScorePointsNames[0], (String)updateScorePointsNames[1], (Class[])new Class[]{IScoreCriteria.class, Integer.TYPE});
            m.setAccessible(true);
            updateScorePoints = MethodHandles.publicLookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

