/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import java.util.Set;
import net.minecraft.util.EnumFacing;
import org.cyclops.integrateddynamics.api.part.PartPos;

public interface IPositionedAddonsNetwork {
    public Set<PrioritizedPartPos> getPositions();

    public boolean addPosition(PartPos var1, int var2, int var3);

    public void removePosition(PartPos var1);

    public boolean isPositionDisabled(PartPos var1);

    public void disablePosition(PartPos var1);

    public void enablePosition(PartPos var1);

    public static class PrioritizedPartPos
    implements Comparable<PrioritizedPartPos> {
        private final PartPos partPos;
        private final int priority;
        private final int channel;

        private PrioritizedPartPos(PartPos partPos, int priority, int channel) {
            this.partPos = partPos;
            this.priority = priority;
            this.channel = channel;
        }

        @Override
        public int compareTo(PrioritizedPartPos o) {
            int compPriority = -Integer.compare(this.getPriority(), o.getPriority());
            if (compPriority == 0) {
                int compPos = this.getPartPos().getPos().compareTo(o.getPartPos().getPos());
                if (compPos == 0) {
                    EnumFacing otherSide;
                    EnumFacing thisSide = this.getPartPos().getSide();
                    return thisSide == (otherSide = o.getPartPos().getSide()) ? Integer.compare(this.getChannel(), o.getChannel()) : (thisSide == null ? -1 : (otherSide == null ? 1 : thisSide.compareTo((Enum)otherSide)));
                }
                return compPos;
            }
            return compPriority;
        }

        public static PrioritizedPartPos of(PartPos pos, int priority, int channel) {
            return new PrioritizedPartPos(pos, priority, channel);
        }

        public PartPos getPartPos() {
            return this.partPos;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getChannel() {
            return this.channel;
        }
    }
}

