/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;

public class BlockEnergyBattery
extends BlockEnergyBatteryBase {
    @Deprecated
    @BlockProperty
    public static final PropertyInteger FILL = PropertyInteger.func_177719_a((String)"fill", (int)0, (int)3);
    @Icon(location="blocks/energy_battery_overlay_side_2")
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite iconOverlay;
    private static BlockEnergyBattery _instance = null;

    public static BlockEnergyBattery getInstance() {
        return _instance;
    }

    public BlockEnergyBattery(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        if (MinecraftHelpers.isClientSide()) {
            eConfig.getMod().getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        int lastCapacity;
        int capacityOriginal;
        if (!BlockHelpers.isValidCreativeTab((Block)this, (CreativeTabs)tab)) {
            return;
        }
        ItemStack itemStack = new ItemStack((Block)this);
        int capacity = capacityOriginal = BlockEnergyBatteryConfig.capacity;
        do {
            ItemStack currentStack = itemStack.func_77946_l();
            IEnergyStorageCapacity energyStorage = (IEnergyStorageCapacity)currentStack.getCapability(CapabilityEnergy.ENERGY, null);
            energyStorage.setCapacity(capacity);
            list.add((Object)currentStack.func_77946_l());
            energyStorage.receiveEnergy(capacity, false);
            list.add((Object)currentStack.func_77946_l());
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(BlockEnergyBatteryConfig.maxCreativeCapacity, BlockEnergyBatteryConfig.maxCapacity) && capacity > lastCapacity);
    }

    @Override
    public boolean isCreative() {
        return false;
    }
}

