/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.core.block.BlockContainerCabled;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public abstract class BlockEnergyBatteryBase
extends BlockContainerCabled
implements IEnergyContainerBlock {
    public BlockEnergyBatteryBase(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, TileEnergyBattery.class);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public String getEneryContainerNBTName() {
        return "energy";
    }

    @Override
    public String getEneryContainerCapacityNBTName() {
        return "capacity";
    }

    public abstract boolean isCreative();

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEnergyBattery tile;
        if (super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (player.func_184586_b(hand).func_190926_b() && (tile = (TileEnergyBattery)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileEnergyBattery.class)) != null) {
            player.func_146105_b((ITextComponent)new TextComponentString(Helpers.getLocalizedEnergyLevel(tile.getEnergyStored(), tile.getMaxEnergyStored())), true);
            return true;
        }
        return false;
    }
}

