/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.partcontainer;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public abstract class PartContainerDefault
implements IPartContainer {
    protected final EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> partData = EnumFacingMap.newMap();

    @Override
    public void update() {
        if (!MinecraftHelpers.isClientSide()) {
            for (PartHelpers.PartStateHolder partStateHolder : this.partData.values()) {
                if (partStateHolder.getState().isDirtyAndReset()) {
                    this.markDirty();
                }
                if (!partStateHolder.getState().isUpdateAndReset()) continue;
                this.sendUpdate();
            }
        }
    }

    @Override
    public DimPos getPosition() {
        return DimPos.of((World)this.getWorld(), (BlockPos)this.getPos());
    }

    @Override
    public Map<EnumFacing, IPartType<?, ?>> getParts() {
        return Maps.transformValues(this.partData, (Function)new Function<PartHelpers.PartStateHolder<?, ?>, IPartType<?, ?>>(){

            @Nullable
            public IPartType<?, ?> apply(@Nullable PartHelpers.PartStateHolder<?, ?> input) {
                return input.getPart();
            }
        });
    }

    @Override
    public boolean hasParts() {
        return !this.partData.isEmpty();
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean canAddPart(EnumFacing side, IPartType<P, S> part) {
        return !this.hasPart(side);
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setPart(final EnumFacing side, final IPartType<P, S> part, final IPartState<P> partState) {
        PartHelpers.setPart(this.getNetwork(), this.getWorld(), this.getPos(), side, Objects.requireNonNull(part), Objects.requireNonNull(partState), new PartHelpers.IPartStateHolderCallback(){

            @Override
            public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                PartContainerDefault.this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(part, partState));
                PartContainerDefault.this.sendUpdate();
            }
        });
        this.onPartsChanged();
    }

    @Override
    public IPartType getPart(EnumFacing side) {
        if (!this.partData.containsKey((Object)side)) {
            return null;
        }
        return ((PartHelpers.PartStateHolder)this.partData.get((Object)side)).getPart();
    }

    @Override
    public boolean hasPart(EnumFacing side) {
        return this.partData.containsKey((Object)side);
    }

    @Override
    public IPartType removePart(EnumFacing side, EntityPlayer player, boolean dropMainElement) {
        PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
        if (partStateHolder == null) {
            IntegratedDynamics.clog(Level.WARN, "Attempted to remove a part at a side where no part was.");
            return null;
        }
        IPartType removed = partStateHolder.getPart();
        if (this.getNetwork() != null) {
            INetworkElement networkElement = removed.createNetworkElement(this, this.getPosition(), side);
            networkElement.onPreRemoved(this.getNetwork());
            if (!this.getNetwork().removeNetworkElementPre(networkElement)) {
                return null;
            }
            LinkedList itemStacks = Lists.newLinkedList();
            networkElement.addDrops(itemStacks, dropMainElement);
            for (ItemStack itemStack : itemStacks) {
                if (player != null) {
                    if (player.field_71075_bZ.field_75098_d) continue;
                    ItemStackHelpers.spawnItemStackToPlayer((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)itemStack, (EntityPlayer)player);
                    continue;
                }
                ItemStackHelpers.spawnItemStack((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)itemStack);
            }
            this.getNetwork().removeNetworkElementPost(networkElement);
            IPartType ret = ((PartHelpers.PartStateHolder)this.partData.remove((Object)side)).getPart();
            networkElement.onPostRemoved(this.getNetwork());
            this.onPartsChanged();
            return ret;
        }
        if (dropMainElement) {
            if (player != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStackHelpers.spawnItemStackToPlayer((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)removed.getItemStack(partStateHolder.getState()), (EntityPlayer)player);
                }
            } else {
                ItemStackHelpers.spawnItemStack((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)removed.getItemStack(partStateHolder.getState()));
            }
        }
        IPartType ret = ((PartHelpers.PartStateHolder)this.partData.remove((Object)side)).getPart();
        this.onPartsChanged();
        return ret;
    }

    @Override
    public void setPartState(EnumFacing side, IPartState partState) throws PartStateException {
        if (!this.hasPart(side)) {
            throw new PartStateException(this.getPosition(), side);
        }
        this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(this.getPart(side), partState));
        this.onPartsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPartState getPartState(EnumFacing side) throws PartStateException {
        EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> enumFacingMap = this.partData;
        synchronized (enumFacingMap) {
            PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
            if (partStateHolder == null) {
                throw new PartStateException(this.getPosition(), side);
            }
            return partStateHolder.getState();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        IPartState partState;
        if (facing == null) {
            for (Map.Entry entry : this.partData.entrySet()) {
                Object partState2 = ((PartHelpers.PartStateHolder)entry.getValue()).getState();
                if (partState2 == null || !partState2.hasCapability(capability)) continue;
                return true;
            }
        } else if (this.hasPart(facing) && (partState = this.getPartState(facing)) != null && partState.hasCapability(capability)) {
            return true;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        IPartState partState;
        if (facing == null) {
            for (Map.Entry entry : this.partData.entrySet()) {
                Object partState2 = ((PartHelpers.PartStateHolder)entry.getValue()).getState();
                if (partState2 == null || !partState2.hasCapability(capability)) continue;
                return partState2.getCapability(capability);
            }
        } else if (this.hasPart(facing) && (partState = this.getPartState(facing)) != null && partState.hasCapability(capability)) {
            return partState.getCapability(capability);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        PartHelpers.writePartsToNBT(this.getPos(), tag, this.partData);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeNBT(NBTTagCompound tag) {
        EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> enumFacingMap = this.partData;
        synchronized (enumFacingMap) {
            PartHelpers.readPartsFromNBT(this.getNetwork(), this.getPos(), tag, this.partData, this.getWorld());
        }
    }

    protected void onPartsChanged() {
        this.markDirty();
        this.sendUpdate();
    }

    protected abstract void markDirty();

    protected abstract void sendUpdate();

    protected abstract World getWorld();

    protected abstract BlockPos getPos();

    protected abstract INetwork getNetwork();

    protected IPartNetwork getPartNetwork() {
        return NetworkHelpers.getPartNetwork(this.getNetwork());
    }

    public EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> getPartData() {
        return this.partData;
    }

    public void setPartData(Map<EnumFacing, PartHelpers.PartStateHolder<?, ?>> partData) {
        this.partData.clear();
        this.partData.putAll(partData);
    }

    public void silentResetPartData() {
        this.partData.clear();
    }
}

