/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ScrollingGuiContainer;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.block.BlockLogicProgrammerConfig;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.item.ItemLabeller;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerActivateElementPacket;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerLabelPacket;
import org.cyclops.integrateddynamics.proxy.ClientProxy;
import org.lwjgl.input.Keyboard;

public class GuiLogicProgrammerBase
extends ScrollingGuiContainer {
    public static final int BOX_HEIGHT = 18;
    private static final Rectangle ITEM_POSITION = new Rectangle(19, 18, 56, 17);
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    private final boolean hasLabeller;
    protected RenderPattern operatorConfigPattern = null;
    protected SubGuiOperatorInfo operatorInfoPattern = null;
    protected boolean firstInit = true;
    protected int relativeStep = -1;

    public GuiLogicProgrammerBase(InventoryPlayer inventoryPlayer, ContainerLogicProgrammerBase container) {
        super((ScrollingInventoryContainer)container);
        container.setGui(this);
        this.hasLabeller = inventoryPlayer.func_70431_c(new ItemStack((Item)ItemLabeller.getInstance()));
    }

    public ContainerLogicProgrammerBase getContainer() {
        return (ContainerLogicProgrammerBase)super.getContainer();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.subGuiHolder.initGui(this.field_147003_i, this.field_147009_r);
        if (this.firstInit) {
            this.setSearchFieldFocussed(true);
            this.firstInit = false;
        }
    }

    protected int getScrollX() {
        return 5;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 178;
    }

    protected int getBaseXSize() {
        return 256;
    }

    protected int getBaseYSize() {
        return 240;
    }

    protected int getSearchX() {
        return 6;
    }

    protected int getSearchWidth() {
        return 70;
    }

    public String getGuiTexture() {
        return (String)this.getContainer().getGuiProvider().getModGui().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + BlockLogicProgrammerConfig._instance.getNamedId() + ".png";
    }

    protected float colorSmoothener(float color, boolean hover) {
        return 1.0f - (1.0f - color) / (hover ? 2.0f : 4.0f);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerBackgroundLayer(this.field_147003_i, this.field_147009_r, this.field_146297_k.field_71446_o, this.field_146289_q, partialTicks, mouseX, mouseY);
        this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.logicprogrammer.filter", (Object[])new Object[0]), this.field_147003_i + this.offsetX + 5, this.field_147009_r + this.offsetY + 208, Helpers.RGBToInt((int)80, (int)80, (int)80));
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.getScrollingInventoryContainer();
        int boxHeight = 18;
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            GlStateManager.func_179118_c();
            Triple rgb = Helpers.intToRGB((int)element.getColor());
            boolean hover = LogicProgrammerElementTypes.areEqual(container.getActiveElement(), element) || this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY));
            GlStateManager.func_179131_c((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue(), hover), (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(this.field_147003_i + this.offsetX + GuiLogicProgrammerBase.ITEM_POSITION.x, this.field_147009_r + this.offsetY + GuiLogicProgrammerBase.ITEM_POSITION.y + boxHeight * i, 19, 18, GuiLogicProgrammerBase.ITEM_POSITION.width, GuiLogicProgrammerBase.ITEM_POSITION.height);
            GlStateManager.func_179141_d();
            if (hover) {
                this.func_73729_b(this.field_147003_i + this.offsetX + GuiLogicProgrammerBase.ITEM_POSITION.x, this.field_147009_r + this.offsetY + GuiLogicProgrammerBase.ITEM_POSITION.y + boxHeight * i, 0, 240, 3, 16);
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            String aspectName = element.getSymbol();
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.field_146289_q, (String)aspectName, (int)(this.field_147003_i + this.offsetX + (hover ? 22 : 21)), (int)(this.field_147009_r + this.offsetY + 26 + boxHeight * i), (int)53, (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
        }
    }

    protected Rectangle getElementPosition(ContainerLogicProgrammerBase container, int i, boolean absolute) {
        return new Rectangle(GuiLogicProgrammerBase.ITEM_POSITION.x + this.offsetX + (absolute ? this.field_147003_i : 0), GuiLogicProgrammerBase.ITEM_POSITION.y + 18 * i + this.offsetY + (absolute ? this.field_147009_r : 0), GuiLogicProgrammerBase.ITEM_POSITION.width, GuiLogicProgrammerBase.ITEM_POSITION.height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerForegroundLayer(this.field_147003_i, this.field_147009_r, this.field_146297_k.field_71446_o, this.field_146289_q, mouseX, mouseY);
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.getScrollingInventoryContainer();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) continue;
            LinkedList lines = Lists.newLinkedList();
            element.loadTooltip(lines);
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void onActivateElement(ILogicProgrammerElement<RenderPattern, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> element) {
        this.operatorInfoPattern = new SubGuiOperatorInfo(element);
        this.subGuiHolder.addSubGui(this.operatorInfoPattern);
        this.operatorInfoPattern.initGui(this.field_147003_i, this.field_147009_r);
        this.operatorConfigPattern = (RenderPattern)element.createSubGui(88, 18, 160, 87, this, this.getContainer());
        this.subGuiHolder.addSubGui(this.operatorConfigPattern);
        this.operatorConfigPattern.initGui(this.field_147003_i, this.field_147009_r);
    }

    protected void onDeactivateElement(ILogicProgrammerElement element) {
        this.subGuiHolder.clear();
    }

    public boolean handleElementActivation(ILogicProgrammerElement element) {
        boolean activate = false;
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.getScrollingInventoryContainer();
        ILogicProgrammerElement newActive = null;
        this.onDeactivateElement(element);
        if (container.getActiveElement() != element) {
            activate = true;
            newActive = element;
            if (element != null) {
                this.onActivateElement(element);
            }
        }
        container.setActiveElement(newActive, this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getX(), this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getY());
        if (newActive != null) {
            ILogicProgrammerElementType type = newActive.getType();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket(type.getName(), type.getName(newActive)));
        } else {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket("", ""));
        }
        return activate;
    }

    protected void setSearchFieldFocussed(boolean focused) {
        this.getSearchField().func_146195_b(focused);
    }

    protected boolean isSearchFieldFocussed() {
        return this.getSearchField().func_146206_l();
    }

    protected boolean selectPageElement(int elementId) {
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.getScrollingInventoryContainer();
        if (elementId < 0) {
            this.handleElementActivation(container.getActiveElement());
            return false;
        }
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i) || elementId-- != 0) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (container.getActiveElement() != element) {
                this.handleElementActivation(element);
            }
            return true;
        }
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 42 && keyCode != 54) {
            boolean isElementFocused;
            ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.getScrollingInventoryContainer();
            int pageSize = container.getPageSize();
            int stepModifier = GuiLogicProgrammerBase.func_146272_n() ? pageSize - 1 : 1;
            boolean bl = isElementFocused = container.getActiveElement() != null && container.getActiveElement().isFocused(this.operatorConfigPattern);
            if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(keyCode)) {
                this.setSearchFieldFocussed(true);
            } else if (isElementFocused && ClientProxy.FOCUS_LP_RENAME.isActiveAndMatches(keyCode) && this.hasLabeller()) {
                this.operatorInfoPattern.onButtonEditClick();
            } else if (203 == keyCode && (isElementFocused || this.isSearchFieldFocussed())) {
                if (isElementFocused) {
                    container.getActiveElement().setFocused(this.operatorConfigPattern, false);
                    this.setSearchFieldFocussed(true);
                } else {
                    this.setSearchFieldFocussed(false);
                }
            } else if (!isElementFocused && 208 == keyCode) {
                if (!this.selectPageElement(this.relativeStep += stepModifier)) {
                    this.relativeStep -= stepModifier;
                    if (this.relativeStep > 0) {
                        this.scrollRelative(-stepModifier);
                        this.selectPageElement(this.relativeStep);
                    }
                }
            } else if (!isElementFocused && 200 == keyCode) {
                if (this.relativeStep < 0 || !this.selectPageElement(this.relativeStep -= stepModifier)) {
                    this.scrollRelative(stepModifier);
                    this.relativeStep = 0;
                    this.selectPageElement(0);
                }
            } else if (!(isElementFocused || 205 != keyCode && 15 != keyCode && 28 != keyCode && 156 != keyCode)) {
                if (container.getActiveElement() != null) {
                    container.getActiveElement().setFocused(this.operatorConfigPattern, true);
                }
            } else if (!(this.subGuiHolder.keyTyped(this.func_146983_a(keyCode), typedChar, keyCode) || keyCode != 1 && isElementFocused)) {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.getScrollingInventoryContainer();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) continue;
            boolean activated = this.handleElementActivation(element);
            int n = this.relativeStep = activated ? i : -1;
            if (!activated) continue;
            container.getActiveElement().setFocused(this.operatorConfigPattern, true);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isSearchFieldFocussed() && container.getActiveElement() != null && container.getActiveElement().isFocused(this.operatorConfigPattern)) {
            container.getActiveElement().setFocused(this.operatorConfigPattern, false);
        }
    }

    protected void label(String label) {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerLabelPacket(label));
    }

    protected boolean hasLabeller() {
        return this.hasLabeller;
    }

    public class SubGuiOperatorInfo
    extends GuiElementValueTypeString.SubGuiValueTypeInfo<RenderPattern, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> {
        public static final int BUTTON_EDIT = 1;
        private GuiTextFieldExtended searchField;
        private GuiButtonText button;

        public SubGuiOperatorInfo(IGuiInputElement<RenderPattern, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> element) {
            super(GuiLogicProgrammerBase.this, (ContainerLogicProgrammerBase)GuiLogicProgrammerBase.this.container, element, 88, 106, 139, 20);
            this.button = null;
            if (GuiLogicProgrammerBase.this.hasLabeller()) {
                this.button = new GuiButtonText(1, 0, 0, 6, 10, "E", true);
                this.buttonList.add(this.button);
            }
            int searchWidth = 113;
            this.searchField = new GuiTextFieldExtended(0, GuiLogicProgrammerBase.this.field_146289_q, 0, 0, searchWidth, 11);
            this.searchField.func_146203_f(64);
            this.searchField.func_146185_a(true);
            this.searchField.func_146189_e(false);
            this.searchField.func_146193_g(0xFFFFFF);
            this.searchField.func_146205_d(true);
            this.searchField.func_146180_a("");
            this.searchField.field_146218_h = searchWidth;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            int searchX = 90;
            int searchY = 110;
            this.searchField.field_146209_f = guiLeft + searchX;
            this.searchField.field_146210_g = guiTop + searchY;
            if (GuiLogicProgrammerBase.this.hasLabeller()) {
                this.button.field_146128_h = guiLeft + 220;
                this.button.field_146129_i = guiTop + 111;
            }
        }

        @Override
        protected boolean showError() {
            return ((ContainerLogicProgrammerBase)this.container).canWriteActiveElementPre();
        }

        @Override
        protected L10NHelpers.UnlocalizedString getLastError() {
            return ((ContainerLogicProgrammerBase)this.container).getLastError();
        }

        @Override
        protected ResourceLocation getTexture() {
            return GuiLogicProgrammerBase.this.texture;
        }

        @Override
        public boolean keyTyped(boolean checkHotbarKeys, char typedChar, int keyCode) throws IOException {
            if (!checkHotbarKeys) {
                if (!this.searchField.func_146176_q() || !this.searchField.func_146201_a(typedChar, keyCode)) {
                    return super.keyTyped(checkHotbarKeys, typedChar, keyCode);
                }
                GuiLogicProgrammerBase.this.label(this.searchField.func_146179_b());
                return true;
            }
            return super.keyTyped(checkHotbarKeys, typedChar, keyCode);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            if (this.searchField.func_146176_q()) {
                this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            Keyboard.enableRepeatEvents((boolean)true);
            this.searchField.func_146194_f();
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton.field_146127_k == 1) {
                this.onButtonEditClick();
            }
        }

        public void onButtonEditClick() {
            this.searchField.func_146189_e(!this.searchField.func_146176_q());
            if (this.searchField.func_146176_q()) {
                this.searchField.func_146195_b(true);
                GuiLogicProgrammerBase.this.label(this.searchField.func_146179_b());
            } else {
                GuiLogicProgrammerBase.this.label("");
            }
        }
    }
}

