/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class RenderTileEntityEnergyBattery
extends TileEntitySpecialRenderer<TileEnergyBattery> {
    private static final double OFFSET = 0.001;
    private static final double MINY = 0.0;
    private static final double MAXY = 1.0;
    private static final double MIN = -0.001;
    private static final double MAX = 1.001;
    private static double[][][] coordinates = new double[][][]{new double[][]{{-0.001, 0.0, -0.001}, {-0.001, 0.0, 1.001}, {1.001, 0.0, 1.001}, {1.001, 0.0, -0.001}}, new double[][]{{-0.001, 1.0, -0.001}, {-0.001, 1.0, 1.001}, {1.001, 1.0, 1.001}, {1.001, 1.0, -0.001}}, new double[][]{{-0.001, 0.0, -0.001}, {-0.001, 1.0, -0.001}, {1.001, 1.0, -0.001}, {1.001, 0.0, -0.001}}, new double[][]{{1.001, 0.0, 1.001}, {1.001, 1.0, 1.001}, {-0.001, 1.0, 1.001}, {-0.001, 0.0, 1.001}}, new double[][]{{-0.001, 0.0, 1.001}, {-0.001, 1.0, 1.001}, {-0.001, 1.0, -0.001}, {-0.001, 0.0, -0.001}}, new double[][]{{1.001, 0.0, -0.001}, {1.001, 1.0, -0.001}, {1.001, 1.0, 1.001}, {1.001, 0.0, 1.001}}};

    public void render(TileEnergyBattery tile, double x, double y, double z, float partialTickTime, int partialDamage, float alpha) {
        if (tile != null && tile.getEnergyStored() > 0) {
            double height = (double)tile.getEnergyStored() / (double)tile.getMaxEnergyStored();
            int brightness = tile.func_145831_w().func_175626_b(tile.func_174877_v(), 15);
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            for (EnumFacing side : EnumFacing.field_176754_o) {
                TextureAtlasSprite icon = BlockEnergyBattery.getInstance().iconOverlay;
                Tessellator t = Tessellator.func_178181_a();
                BufferBuilder worldRenderer = t.func_178180_c();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                double[][] c = coordinates[side.ordinal()];
                double replacedMaxV = icon.func_94210_h();
                double replacedMinV = (double)(icon.func_94206_g() - icon.func_94210_h()) * height + (double)icon.func_94210_h();
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (tile.isCreative()) {
                    float tickFactor = (float)tile.func_145831_w().func_82737_E() % 20.0f / 10.0f;
                    if (tickFactor > 1.0f) {
                        tickFactor = -tickFactor + 1.0f;
                    }
                    r = 0.8f + 0.2f * tickFactor;
                    g = 0.42f;
                    b = 0.6f + 0.4f * tickFactor;
                }
                worldRenderer.func_181662_b(c[0][0], c[0][1] * height, c[0][2]).func_187315_a((double)icon.func_94209_e(), replacedMaxV).func_187314_a(l2, i3).func_181666_a(r, g, b, 1.0f).func_181675_d();
                worldRenderer.func_181662_b(c[1][0], c[1][1] * height, c[1][2]).func_187315_a((double)icon.func_94209_e(), replacedMinV).func_187314_a(l2, i3).func_181666_a(r, g, b, 1.0f).func_181675_d();
                worldRenderer.func_181662_b(c[2][0], c[2][1] * height, c[2][2]).func_187315_a((double)icon.func_94212_f(), replacedMinV).func_187314_a(l2, i3).func_181666_a(r, g, b, 1.0f).func_181675_d();
                worldRenderer.func_181662_b(c[3][0], c[3][1] * height, c[3][2]).func_187315_a((double)icon.func_94212_f(), replacedMaxV).func_187314_a(l2, i3).func_181666_a(r, g, b, 1.0f).func_181675_d();
                t.func_78381_a();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }
}

