/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;

public class ExtendedGuiHandler
extends GuiHandler {
    public static final GuiHandler.GuiType<EnumFacing> PART = GuiHandler.GuiType.create((boolean)true);
    public static final GuiHandler.GuiType<Pair<EnumFacing, IAspect>> ASPECT = GuiHandler.GuiType.create((boolean)true);

    private static Triple<IPartContainer, PartTypeBase, PartTarget> getPartConstructionData(World world, BlockPos pos, EnumFacing side) {
        IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos);
        if (partContainer == null) {
            IntegratedDynamics.clog(Level.WARN, String.format("The tile at %s is not a valid part container.", pos));
            return null;
        }
        IPartType partType = partContainer.getPart(side);
        if (partType == null || !(partType instanceof PartTypeBase)) {
            IntegratedDynamics.clog(Level.WARN, String.format("The part container at %s side %s does not have a valid part.", pos, side));
            return null;
        }
        PartTarget target = partType.getTarget(PartPos.of(DimPos.of((World)world, (BlockPos)pos), side), partContainer.getPartState(side));
        return Triple.of((Object)partContainer, (Object)((PartTypeBase)partType), (Object)target);
    }

    public ExtendedGuiHandler(ModBase mod) {
        super(mod);
    }

    static {
        PART.setContainerConstructor((GuiHandler.IContainerConstructor)new GuiHandler.IContainerConstructor<EnumFacing>(){

            public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends Container> containerClass, EnumFacing side) {
                try {
                    Constructor<? extends Container> containerConstructor;
                    Triple data = ExtendedGuiHandler.getPartConstructionData(world, new BlockPos(x, y, z), side);
                    if (data == null) {
                        return null;
                    }
                    try {
                        containerConstructor = containerClass.getConstructor(EntityPlayer.class, PartTarget.class, IPartContainer.class, ((PartTypeBase)data.getMiddle()).getPartTypeClass());
                    }
                    catch (NoSuchMethodException e) {
                        containerConstructor = containerClass.getConstructor(EntityPlayer.class, PartTarget.class, IPartContainer.class, IPartType.class);
                    }
                    return containerConstructor.newInstance(player, data.getRight(), data.getLeft(), data.getMiddle());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        if (MinecraftHelpers.isClientSide()) {
            PART.setGuiConstructor((GuiHandler.IGuiConstructor)new GuiHandler.IGuiConstructor<EnumFacing>(){

                public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends GuiScreen> guiClass, EnumFacing side) {
                    try {
                        Constructor<? extends GuiScreen> guiConstructor;
                        Triple data = ExtendedGuiHandler.getPartConstructionData(world, new BlockPos(x, y, z), side);
                        if (data == null) {
                            return null;
                        }
                        try {
                            guiConstructor = guiClass.getConstructor(EntityPlayer.class, PartTarget.class, IPartContainer.class, ((PartTypeBase)data.getMiddle()).getPartTypeClass());
                        }
                        catch (NoSuchMethodException e) {
                            guiConstructor = guiClass.getConstructor(EntityPlayer.class, PartTarget.class, IPartContainer.class, IPartType.class);
                        }
                        return guiConstructor.newInstance(player, data.getRight(), data.getLeft(), data.getMiddle());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
        ASPECT.setContainerConstructor((GuiHandler.IContainerConstructor)new GuiHandler.IContainerConstructor<Pair<EnumFacing, IAspect>>(){

            public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends Container> containerClass, Pair<EnumFacing, IAspect> dataIn) {
                try {
                    Triple data = ExtendedGuiHandler.getPartConstructionData(world, new BlockPos(x, y, z), (EnumFacing)dataIn.getLeft());
                    if (data == null) {
                        return null;
                    }
                    Constructor<? extends Container> containerConstructor = containerClass.getConstructor(EntityPlayer.class, PartTarget.class, IPartContainer.class, IPartType.class, IAspect.class);
                    return containerConstructor.newInstance(player, data.getRight(), data.getLeft(), data.getMiddle(), dataIn.getRight());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        if (MinecraftHelpers.isClientSide()) {
            ASPECT.setGuiConstructor((GuiHandler.IGuiConstructor)new GuiHandler.IGuiConstructor<Pair<EnumFacing, IAspect>>(){

                public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends GuiScreen> guiClass, Pair<EnumFacing, IAspect> dataIn) {
                    try {
                        Triple data = ExtendedGuiHandler.getPartConstructionData(world, new BlockPos(x, y, z), (EnumFacing)dataIn.getLeft());
                        if (data == null) {
                            return null;
                        }
                        Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(EntityPlayer.class, PartTarget.class, IPartContainer.class, IPartType.class, IAspect.class);
                        return guiConstructor.newInstance(player, data.getRight(), data.getLeft(), data.getMiddle(), dataIn.getRight());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
    }
}

