/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;

public abstract class ValueTypeListProxyBase<T extends IValueType<V>, V extends IValue>
implements IValueTypeListProxy<T, V> {
    private final String name;
    private final T valueType;

    public ValueTypeListProxyBase(String name, T valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    @Override
    public T getValueType() {
        return this.valueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("[");
        for (IValue value : this) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(this.getValueType().toCompactString((IValue)value));
            if (sb.toString().length() <= 10) continue;
            sb.append("...");
            break;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueTypeList.ListFactoryIterator(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ValueTypeListProxyBase)) {
            return false;
        }
        ValueTypeListProxyBase other = (ValueTypeListProxyBase)obj;
        if (!this.getName().equals(other.getName()) || !this.getValueType().equals(other.getValueType())) {
            return false;
        }
        if (this.isInfinite() || other.isInfinite()) {
            return false;
        }
        Object[] o = Iterables.toArray((Iterable)this, Object.class);
        Object[] o2 = Iterables.toArray((Iterable)other, Object.class);
        return Arrays.equals(o, o2);
    }

    public int hashCode() {
        if (this.isInfinite()) {
            return System.identityHashCode(this);
        }
        int result = 1;
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.getValueType().hashCode();
        for (V obj : this) {
            result = 37 * result + (obj != null ? obj.hashCode() : 0);
        }
        return result;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }
}

