/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;

public final class Helpers {
    public static final Predicate<Entity> SELECTOR_IS_PLAYER = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityPlayer;
        }
    };
    private static final List<IInterfaceRetriever> INTERFACE_RETRIEVERS = Lists.newArrayList();

    public static FluidStack getFluidStack(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        if (fluidStack == null && itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof IFluidBlock) {
            fluidStack = new FluidStack(((IFluidBlock)((ItemBlock)itemStack.func_77973_b()).func_179223_d()).getFluid(), 1000);
        }
        return fluidStack;
    }

    public static int getFluidStackCapacity(ItemStack itemStack) {
        IFluidTankProperties[] iFluidTankPropertiesArray;
        int n;
        int n2;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler != null && (n2 = 0) < (n = (iFluidTankPropertiesArray = fluidHandler.getTankProperties()).length)) {
            IFluidTankProperties properties = iFluidTankPropertiesArray[n2];
            return properties.getCapacity();
        }
        return 0;
    }

    public static <T> List<T> joinList(List<T> list, T newElement) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(list);
        if (newElement != null) {
            builder.add(newElement);
        }
        return builder.build();
    }

    public static String createPatternOfLength(int length) {
        StringBuilder pattern = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            if (first) {
                first = false;
            } else {
                pattern.append(",");
            }
            pattern.append("%s");
        }
        return pattern.toString();
    }

    private static <C> C getInterface(IBlockAccess world, BlockPos pos, Class<C> clazz) {
        for (IInterfaceRetriever interfaceRetriever : INTERFACE_RETRIEVERS) {
            C instance = interfaceRetriever.getInterface(world, pos, clazz);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public static <C> C getInterface(DimPos dimPos, Class<C> clazz) {
        World world = dimPos.getWorld();
        return world != null ? (C)Helpers.getInterface((IBlockAccess)world, dimPos.getBlockPos(), clazz) : null;
    }

    public static String getLocalizedEnergyLevel(int stored, int capacity) {
        return String.format("%,d", stored) + " / " + String.format("%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energy_unit.name", (Object[])new Object[0]);
    }

    public static void addInterfaceRetriever(IInterfaceRetriever interfaceRetriever) {
        INTERFACE_RETRIEVERS.add(interfaceRetriever);
    }

    static {
        Helpers.addInterfaceRetriever(new IInterfaceRetriever(){

            @Override
            public <C> C getInterface(IBlockAccess world, BlockPos pos, Class<C> clazz) {
                return (C)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, clazz);
            }
        });
    }

    public static interface IInterfaceRetriever {
        public <C> C getInterface(IBlockAccess var1, BlockPos var2, Class<C> var3);
    }
}

