/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionServer;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;

public class ContainerPartSettings
extends ExtendedInventoryContainer {
    public static final int BUTTON_SETTINGS = 1;
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final World world;
    private final BlockPos pos;
    private final int lastUpdateValueId;
    private final int lastPriorityValueId;
    private final int lastChannelValueId;
    private final int lastSideValueId;

    public ContainerPartSettings(final EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super(player.field_71071_by, (IGuiContainerProvider)partType);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = player.func_130014_f_();
        this.pos = player.func_180425_c();
        this.addPlayerInventory(player.field_71071_by, 27, 107);
        this.lastUpdateValueId = this.getNextValueId();
        this.lastPriorityValueId = this.getNextValueId();
        this.lastChannelValueId = this.getNextValueId();
        this.lastSideValueId = this.getNextValueId();
        this.putButtonAction(0, (IButtonActionServer)new IButtonActionServer<InventoryContainer>(){

            public void onAction(int buttonId, InventoryContainer container) {
                if (!(ContainerPartSettings.this.getPartType() instanceof IGuiContainerProvider) || ((IGuiContainerProvider)ContainerPartSettings.this.getPartType()).getContainer() != ((Object)((Object)ContainerPartSettings.this)).getClass()) {
                    if (!((ContainerPartSettings)ContainerPartSettings.this).world.field_72995_K) {
                        IntegratedDynamics._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)ContainerPartSettings.this.getTarget().getCenter().getSide());
                        BlockPos pos = ContainerPartSettings.this.getTarget().getCenter().getPos().getBlockPos();
                        player.openGui((Object)IntegratedDynamics._instance.getModId(), ((IGuiContainerProvider)ContainerPartSettings.this.getPartType()).getGuiID(), ContainerPartSettings.this.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                } else {
                    player.func_71053_j();
                }
            }
        });
    }

    protected void initializeValues() {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastUpdateValueId, (int)this.getPartType().getUpdateInterval(this.getPartState()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastPriorityValueId, (int)this.getPartType().getPriority(this.getPartState()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastChannelValueId, (int)this.getPartType().getChannel(this.getPartState()));
        EnumFacing targetSide = this.getPartType().getTargetSideOverride(this.getPartState());
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastSideValueId, (int)(targetSide == null ? -1 : targetSide.ordinal()));
    }

    public int getLastUpdateValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastUpdateValueId);
    }

    public int getLastPriorityValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastPriorityValueId);
    }

    public int getLastChannelValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastChannelValueId);
    }

    public int getLastSideValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastSideValueId);
    }

    public IPartState getPartState() {
        return this.partContainer.getPartState(this.getTarget().getCenter().getSide());
    }

    public boolean func_75145_c(EntityPlayer player) {
        return PartHelpers.canInteractWith(this.getTarget(), player, this.partContainer);
    }

    protected int getSizeInventory() {
        return 0;
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        try {
            if (!this.world.field_72995_K) {
                this.getPartType().setUpdateInterval(this.getPartState(), this.getLastUpdateValue());
                DimPos dimPos = this.getTarget().getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)dimPos.getWorld(), dimPos.getBlockPos());
                PartTarget target = this.getTarget();
                EnumFacing targetSide = this.getLastSideValue() >= 0 ? EnumFacing.field_82609_l[this.getLastSideValue()] : null;
                this.getPartType().setTargetSideOverride(this.getPartState(), targetSide);
                if (targetSide != null) {
                    target = target.forTargetSide(targetSide);
                }
                PartNetworkElement networkElement = new PartNetworkElement(this.getPartType(), target);
                network.setPriorityAndChannel(networkElement, this.getLastPriorityValue(), this.getLastChannelValue());
            }
        }
        catch (PartStateException e) {
            this.player.func_71053_j();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerPartSettings)) {
            return false;
        }
        ContainerPartSettings other = (ContainerPartSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        IPartType this$partType = this.getPartType();
        IPartType other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        if (this.getLastUpdateValueId() != other.getLastUpdateValueId()) {
            return false;
        }
        if (this.getLastPriorityValueId() != other.getLastPriorityValueId()) {
            return false;
        }
        if (this.getLastChannelValueId() != other.getLastChannelValueId()) {
            return false;
        }
        return this.getLastSideValueId() == other.getLastSideValueId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerPartSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 43 : $partContainer.hashCode());
        IPartType $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        result = result * 59 + this.getLastUpdateValueId();
        result = result * 59 + this.getLastPriorityValueId();
        result = result * 59 + this.getLastChannelValueId();
        result = result * 59 + this.getLastSideValueId();
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getLastUpdateValueId() {
        return this.lastUpdateValueId;
    }

    public int getLastPriorityValueId() {
        return this.lastPriorityValueId;
    }

    public int getLastChannelValueId() {
        return this.lastChannelValueId;
    }

    public int getLastSideValueId() {
        return this.lastSideValueId;
    }

    public String toString() {
        return "ContainerPartSettings(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", world=" + this.getWorld() + ", pos=" + this.getPos() + ", lastUpdateValueId=" + this.getLastUpdateValueId() + ", lastPriorityValueId=" + this.getLastPriorityValueId() + ", lastChannelValueId=" + this.getLastChannelValueId() + ", lastSideValueId=" + this.getLastSideValueId() + ")";
    }
}

