/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.network.IChanneledNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.core.network.EnergyNetwork;

public class EnergyChannel
implements IEnergyStorage {
    private final EnergyNetwork network;
    private final int channel;

    public EnergyChannel(EnergyNetwork network, int channel) {
        this.network = network;
        this.channel = channel;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int toAdd = energy = Math.min(energy, GeneralConfig.energyRateLimit);
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            IEnergyStorage energyStorage;
            if (!IChanneledNetwork.channelsMatch(partPos.getChannel(), this.channel) || (energyStorage = this.network.getEnergyStorage(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            toAdd -= energyStorage.receiveEnergy(toAdd, simulate);
            this.network.enablePosition(partPos.getPartPos());
        }
        return energy - toAdd;
    }

    public int extractEnergy(int energy, boolean simulate) {
        int toConsume = energy = Math.min(energy, GeneralConfig.energyRateLimit);
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            IEnergyStorage energyStorage;
            if (!IChanneledNetwork.channelsMatch(partPos.getChannel(), this.channel) || (energyStorage = this.network.getEnergyStorage(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            toConsume -= energyStorage.extractEnergy(toConsume, simulate);
            this.network.enablePosition(partPos.getPartPos());
        }
        return energy - toConsume;
    }

    public int getEnergyStored() {
        int energy = 0;
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            IEnergyStorage energyStorage;
            if (!IChanneledNetwork.channelsMatch(partPos.getChannel(), this.channel) || (energyStorage = this.network.getEnergyStorage(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            energy = EnergyNetwork.addSafe(energy, energyStorage.getEnergyStored());
            this.network.enablePosition(partPos.getPartPos());
        }
        return energy;
    }

    public int getMaxEnergyStored() {
        int maxEnergy = 0;
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions()) {
            IEnergyStorage energyStorage;
            if (!IChanneledNetwork.channelsMatch(partPos.getChannel(), this.channel) || (energyStorage = this.network.getEnergyStorage(partPos)) == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            maxEnergy = EnergyNetwork.addSafe(maxEnergy, energyStorage.getMaxEnergyStored());
            this.network.enablePosition(partPos.getPartPos());
        }
        return maxEnergy;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

