/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.IEnergyConsumingNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.NetworkElementBase;

public class PartNetworkElement<P extends IPartType<P, S>, S extends IPartState<P>>
extends NetworkElementBase
implements IPartNetworkElement<P, S>,
IEnergyConsumingNetworkElement {
    private final P part;
    private final PartTarget target;
    private S tempState = null;

    protected static DimPos getCenterPos(PartTarget target) {
        return target.getCenter().getPos();
    }

    protected static EnumFacing getCenterSide(PartTarget target) {
        return target.getCenter().getSide();
    }

    protected static DimPos getTargetPos(PartTarget target) {
        return target.getTarget().getPos();
    }

    protected static EnumFacing getTargetSide(PartTarget target) {
        return target.getTarget().getSide();
    }

    @Override
    public IPartContainer getPartContainer() {
        return PartHelpers.getPartContainer(PartNetworkElement.getCenterPos(this.getTarget()));
    }

    @Override
    public void setPriorityAndChannel(INetwork network, int priority, int channel) {
        this.part.setPriorityAndChannel(network, NetworkHelpers.getPartNetwork(network), this.getTarget(), this.getPartState(), priority, channel);
    }

    @Override
    public int getPriority() {
        return this.hasPartState() ? this.part.getPriority(this.getPartState()) : 0;
    }

    @Override
    public int getChannel() {
        return this.hasPartState() ? this.part.getChannel(this.getPartState()) : 0;
    }

    @Override
    public boolean canRevalidate(INetwork network) {
        return this.canRevalidatePositioned(network, PartNetworkElement.getCenterPos(this.getTarget()));
    }

    @Override
    public void revalidate(INetwork network) {
        super.revalidate(network);
        this.revalidatePositioned(network, PartNetworkElement.getCenterPos(this.getTarget()));
    }

    @Override
    public boolean isLoaded() {
        return PartNetworkElement.getCenterPos(this.getTarget()).isLoaded();
    }

    public boolean hasPartState() {
        if (this.isLoaded()) {
            IPartContainer partContainer = this.getPartContainer();
            return partContainer != null && partContainer.hasPart(PartNetworkElement.getCenterSide(this.getTarget()));
        }
        return false;
    }

    @Override
    public S getPartState() throws PartStateException {
        IPartContainer partContainer = this.getPartContainer();
        if (partContainer != null) {
            return (S)partContainer.getPartState(PartNetworkElement.getCenterSide(this.getTarget()));
        }
        throw new PartStateException(PartNetworkElement.getCenterPos(this.getTarget()), this.getTarget().getCenter().getSide());
    }

    @Override
    public int getConsumptionRate() {
        return this.getPart().getConsumptionRate(this.getPartState());
    }

    @Override
    public void postUpdate(INetwork network, boolean updated) {
        this.part.postUpdate(network, NetworkHelpers.getPartNetwork(network), this.getTarget(), this.getPartState(), updated);
    }

    @Override
    public int getUpdateInterval() {
        return this.part.getUpdateInterval(this.getPartState());
    }

    @Override
    public boolean isUpdate() {
        return this.part.isUpdate(this.getPartState());
    }

    @Override
    public void update(INetwork network) {
        this.part.update(network, NetworkHelpers.getPartNetwork(network), this.getTarget(), this.getPartState());
    }

    @Override
    public void beforeNetworkKill(INetwork network) {
        this.part.beforeNetworkKill(network, NetworkHelpers.getPartNetwork(network), this.target, this.getPartState());
    }

    @Override
    public void afterNetworkAlive(INetwork network) {
        this.part.afterNetworkAlive(network, NetworkHelpers.getPartNetwork(network), this.target, this.getPartState());
    }

    @Override
    public void afterNetworkReAlive(INetwork network) {
        this.part.afterNetworkReAlive(network, NetworkHelpers.getPartNetwork(network), this.target, this.getPartState());
    }

    @Override
    public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement) {
        this.part.addDrops(this.getTarget(), this.getPartState(), itemStacks, dropMainElement);
    }

    @Override
    public boolean onNetworkAddition(INetwork network) {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
        boolean res = partNetwork.addPart(this.getPartState().getId(), this.getTarget().getCenter());
        if (res) {
            this.part.onNetworkAddition(network, partNetwork, this.target, this.getPartState());
        }
        return res;
    }

    @Override
    public void onNetworkRemoval(INetwork network) {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
        partNetwork.removePart(this.getPartState().getId());
        this.part.onNetworkRemoval(network, partNetwork, this.target, this.getPartState());
    }

    @Override
    public void onPreRemoved(INetwork network) {
        this.tempState = this.getPartState();
        this.part.onPreRemoved(network, NetworkHelpers.getPartNetwork(network), this.target, this.tempState);
    }

    @Override
    public void onPostRemoved(INetwork network) {
        this.part.onPostRemoved(network, NetworkHelpers.getPartNetwork(network), this.target, (IPartState)((IPartState)Objects.requireNonNull(this.tempState)));
        this.tempState = null;
    }

    @Override
    public void onNeighborBlockChange(@Nullable INetwork network, IBlockAccess world, Block neighborBlock) {
        this.part.onBlockNeighborChange(network, NetworkHelpers.getPartNetwork(network), this.target, this.getPartState(), world, neighborBlock);
    }

    @Override
    public P getNetworkEventListener() {
        return this.getPart();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof IPartNetworkElement && this.compareTo((INetworkElement)o) == 0;
    }

    @Override
    public int hashCode() {
        int result = this.part.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.getPriority();
        return result;
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof IPartNetworkElement) {
            IPartNetworkElement p = (IPartNetworkElement)o;
            int compClass = this.getPart().getClass().getCanonicalName().compareTo(p.getPart().getClass().getCanonicalName());
            if (compClass == 0) {
                int compPriority;
                int n = compPriority = !this.isLoaded() || !p.isLoaded() ? 0 : -Integer.compare(this.getPriority(), p.getPriority());
                if (compPriority == 0) {
                    int compPart = this.getPart().getUnlocalizedName().compareTo(p.getPart().getUnlocalizedName());
                    if (compPart == 0) {
                        int compPos = PartNetworkElement.getCenterPos(this.getTarget()).compareTo(PartNetworkElement.getCenterPos(p.getTarget()));
                        if (compPos == 0) {
                            return PartNetworkElement.getCenterSide(this.getTarget()).compareTo((Enum)PartNetworkElement.getCenterSide(p.getTarget()));
                        }
                        return compPos;
                    }
                    return compPart;
                }
                return compPriority;
            }
            return compClass;
        }
        return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
    }

    @ConstructorProperties(value={"part", "target"})
    public PartNetworkElement(P part, PartTarget target) {
        this.part = part;
        this.target = target;
    }

    @Override
    public P getPart() {
        return this.part;
    }

    @Override
    public PartTarget getTarget() {
        return this.target;
    }

    public S getTempState() {
        return this.tempState;
    }

    public void setTempState(S tempState) {
        this.tempState = tempState;
    }

    @Override
    public String toString() {
        return "PartNetworkElement(part=" + this.getPart() + ", target=" + this.getTarget() + ", tempState=" + this.getTempState() + ")";
    }
}

