/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class PositionedAddonsNetwork
implements IPositionedAddonsNetwork {
    private INetwork network;
    private final TreeSet<IPositionedAddonsNetwork.PrioritizedPartPos> positions = Sets.newTreeSet();
    private final Set<PartPos> disabledPositions = Sets.newHashSet();

    @Override
    public Set<IPositionedAddonsNetwork.PrioritizedPartPos> getPositions() {
        return ImmutableSet.copyOf(this.positions);
    }

    @Override
    public boolean addPosition(PartPos pos, int priority, int channel) {
        return this.positions.add(IPositionedAddonsNetwork.PrioritizedPartPos.of(pos, priority, channel));
    }

    @Override
    public void removePosition(PartPos pos) {
        Iterator<IPositionedAddonsNetwork.PrioritizedPartPos> it = this.positions.iterator();
        while (it.hasNext()) {
            if (!it.next().getPartPos().equals(pos)) continue;
            it.remove();
        }
    }

    @Override
    public boolean isPositionDisabled(PartPos pos) {
        return this.disabledPositions.contains(pos);
    }

    @Override
    public void disablePosition(PartPos pos) {
        this.disabledPositions.add(pos);
    }

    @Override
    public void enablePosition(PartPos pos) {
        this.disabledPositions.remove(pos);
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(INetwork network) {
        this.network = network;
    }
}

