/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.item.ItemVariable;

public abstract class PartStateActiveVariableBase<P extends IPartType>
extends PartStateBase<P> {
    private boolean checkedForWriteVariable = false;
    protected IVariableFacade currentVariableFacade = null;
    private boolean deactivated = false;
    private SimpleInventory inventory;
    private List<L10NHelpers.UnlocalizedString> globalErrorMessages = Lists.newLinkedList();

    public PartStateActiveVariableBase(int inventorySize) {
        this.inventory = new SingularInventory(inventorySize);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    protected void validate(IPartNetwork network) {
        this.currentVariableFacade.validate(network, new Validator(this), this.currentVariableFacade.getOutputType());
    }

    protected void onCorruptedState() {
        IntegratedDynamics.clog(Level.WARN, "A corrupted part state was found at, repairing...");
        this.checkedForWriteVariable = false;
        this.deactivated = true;
    }

    public boolean hasVariable() {
        return this.getGlobalErrors().isEmpty() && !this.getInventory().func_191420_l();
    }

    public <V extends IValue> IVariable<V> getVariable(IPartNetwork network) {
        if (!this.checkedForWriteVariable) {
            for (int slot = 0; slot < this.getInventory().func_70302_i_(); ++slot) {
                ItemStack itemStack = this.getInventory().func_70301_a(slot);
                if (itemStack.func_190926_b()) continue;
                this.currentVariableFacade = ItemVariable.getInstance().getVariableFacade(itemStack);
                this.validate(network);
            }
            this.checkedForWriteVariable = true;
        }
        if (this.currentVariableFacade == null) {
            this.onCorruptedState();
            return null;
        }
        return this.currentVariableFacade.getVariable(network);
    }

    public void onVariableContentsUpdated(P partType, PartTarget target) {
        this.checkedForWriteVariable = false;
        this.addGlobalError(null);
        this.currentVariableFacade = null;
    }

    public List<L10NHelpers.UnlocalizedString> getGlobalErrors() {
        return this.globalErrorMessages;
    }

    public void addGlobalError(L10NHelpers.UnlocalizedString error) {
        if (error == null) {
            this.globalErrorMessages.clear();
        } else {
            this.globalErrorMessages.add(error);
        }
        this.onDirty();
        this.sendUpdate();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTClassType.writeNbt(List.class, (String)"globalErrorMessages", this.globalErrorMessages, (NBTTagCompound)tag);
        this.inventory.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.globalErrorMessages = (List)NBTClassType.readNbt(List.class, (String)"globalErrorMessages", (NBTTagCompound)tag);
        this.inventory.readFromNBT(tag);
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(boolean deactivated) {
        this.deactivated = deactivated;
    }

    public static class Validator
    implements IVariableFacade.IValidator {
        private final PartStateActiveVariableBase state;

        public Validator(PartStateActiveVariableBase state) {
            this.state = state;
        }

        @Override
        public void addError(L10NHelpers.UnlocalizedString error) {
            this.state.addGlobalError(error);
        }
    }

    public static class SingularInventory
    extends SimpleInventory {
        public SingularInventory(int size) {
            super(size, "stateInventory", 1);
        }

        protected boolean canInsert(int slot) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (i == slot || this.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return this.canInsert(i) && super.func_94041_b(i, itemstack);
        }
    }
}

